/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.util.List;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ImportSourcePage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ReviewImportedQuotesPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class ImportQuotesWizard
extends Wizard {
    private final Security security;
    private ImportSourcePage importPage;
    private ReviewImportedQuotesPage reviewPage;

    public ImportQuotesWizard(Security security) {
        this.security = security;
    }

    public Image getDefaultPageImage() {
        return Images.BANNER.image();
    }

    public void addPages() {
        this.importPage = new ImportSourcePage(this.security);
        this.addPage((IWizardPage)this.importPage);
        this.reviewPage = new ReviewImportedQuotesPage(this.importPage);
        this.addPage((IWizardPage)this.reviewPage);
        AbstractWizardPage.attachPageListenerTo(this.getContainer());
    }

    public boolean performFinish() {
        List<LatestSecurityPrice> quotes = this.reviewPage.getQuotes();
        for (LatestSecurityPrice p : quotes) {
            SecurityPrice quote = new SecurityPrice(p.getDate(), p.getValue());
            this.security.addPrice(quote);
        }
        return true;
    }
}

