/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.ImportAction;

public class ExtractedEntry {
    private final Extractor.Item item;
    private Boolean isImported = null;
    private ImportAction.Status.Code maxCode = ImportAction.Status.Code.OK;
    private List<ImportAction.Status> status = new ArrayList<ImportAction.Status>();

    public ExtractedEntry(Extractor.Item item) {
        this.item = item;
    }

    public Extractor.Item getItem() {
        return this.item;
    }

    public void setImported(boolean isImported) {
        this.isImported = isImported;
    }

    public boolean isImported() {
        if (this.isImported != null && !this.isImported.booleanValue()) {
            return false;
        }
        return this.maxCode == ImportAction.Status.Code.OK || this.maxCode == ImportAction.Status.Code.WARNING && this.isImported != null && this.isImported != false || this.maxCode == ImportAction.Status.Code.WARNING && this.item.isInvestmentPlanItem();
    }

    public void addStatus(ImportAction.Status status) {
        this.status.add(status);
        if (status.getCode().isHigherSeverityAs(this.maxCode)) {
            this.maxCode = status.getCode();
        }
    }

    public Stream<ImportAction.Status> getStatus() {
        return this.status.stream();
    }

    public ImportAction.Status.Code getMaxCode() {
        return this.maxCode;
    }

    public void clearStatus() {
        this.status.clear();
        this.maxCode = ImportAction.Status.Code.OK;
    }
}

