/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.csv.CSVConfig;
import name.abuchen.portfolio.datatransfer.csv.CSVConfigManager;
import name.abuchen.portfolio.datatransfer.csv.CSVExtractor;
import name.abuchen.portfolio.datatransfer.csv.CSVImporter;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupportWrapper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.Delimiter;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class CSVImportDefinitionPage
extends AbstractWizardPage {
    private final Client client;
    private final CSVImporter importer;
    private String currentConfigLabel;
    private CSVConfigManager configManager;
    private final boolean onlySecurityPrices;
    private TableViewer tableViewer;
    private Menu configurationDropDownMenu;
    private DataBindingContext context;

    public CSVImportDefinitionPage(Client client, CSVImporter importer, CSVConfigManager configManager, boolean onlySecurityPrices) {
        super("importdefinition");
        this.setTitle(Messages.CSVImportWizardTitle);
        this.setDescription(Messages.CSVImportWizardDescription);
        this.client = client;
        this.importer = importer;
        this.configManager = configManager;
        this.onlySecurityPrices = onlySecurityPrices;
        importer.setExtractor(onlySecurityPrices ? importer.getSecurityPriceExtractor() : (CSVExtractor)importer.getExtractors().get(0));
        this.context = new DataBindingContext();
    }

    public CSVImporter getImporter() {
        return this.importer;
    }

    public void setInitialConfiguration(CSVConfig config) {
        this.currentConfigLabel = Objects.requireNonNull(config).getLabel();
        config.writeTo(this.importer);
    }

    public IWizardPage getNextPage() {
        if (this.onlySecurityPrices) {
            return null;
        }
        if (this.importer.getExtractor() == this.importer.getSecurityPriceExtractor()) {
            return this.getWizard().getPage("select-security-page");
        }
        return this.getWizard().getPage("reviewitems");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Label lblExtractor = new Label(container, 131072);
        lblExtractor.setText(Messages.CSVImportLabelTarget);
        ComboViewer extractor = this.createExtractorComboViewer(container);
        Button button = new Button(container, 0);
        button.setImage(Images.CONFIG.image());
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.onConfigurationDropDown(button)));
        Label lblDelimiter = new Label(container, 0);
        lblDelimiter.setText(Messages.CSVImportLabelDelimiter);
        ComboViewer delimiter = this.createDelimiterComboViewer(container);
        Label lblSkipLines = new Label(container, 0);
        lblSkipLines.setText(Messages.CSVImportLabelSkipLines);
        Spinner skipLines = new Spinner(container, 2048);
        skipLines.setMinimum(0);
        ISWTObservableValue spinnerTarget = WidgetProperties.spinnerSelection().observe((Widget)skipLines);
        IObservableValue spinnerModel = BeanProperties.value((String)"skipLines", Integer.class).observe((Object)this.importer);
        this.context.bindValue((IObservableValue)spinnerTarget, spinnerModel);
        skipLines.addModifyListener(event -> this.doProcessFile());
        Label lblEncoding = new Label(container, 0);
        lblEncoding.setText(Messages.CSVImportLabelEncoding);
        Combo cmbEncoding = new Combo(container, 8);
        ComboViewer encoding = new ComboViewer(cmbEncoding);
        encoding.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        encoding.setInput((Object)Charset.availableCharsets().values().toArray());
        IViewerObservableValue encodingTarget = ViewerProperties.singleSelection().observe((Viewer)encoding);
        IObservableValue encodingModel = BeanProperties.value((String)"encoding").observe((Object)this.importer);
        this.context.bindValue((IObservableValue)encodingTarget, encodingModel);
        encoding.addSelectionChangedListener(event -> this.doProcessFile());
        Button firstLineIsHeader = new Button(container, 32);
        firstLineIsHeader.setText(Messages.CSVImportLabelFirstLineIsHeader);
        ISWTObservableValue targetObservable = WidgetProperties.buttonSelection().observe((Widget)firstLineIsHeader);
        IObservableValue modelObservable = BeanProperties.value((String)"firstLineHeader").observe((Object)this.importer);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        firstLineIsHeader.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doProcessFile()));
        Composite compositeTable = new Composite(container, 0);
        int width = SWTHelper.widest(new Control[]{lblExtractor, lblDelimiter, lblEncoding});
        FormDataFactory.startingWith((Control)lblExtractor).width(width).top(new FormAttachment(0, 5)).thenRight((Control)extractor.getCombo()).right(new FormAttachment(50, -5)).thenBelow((Control)delimiter.getCombo()).label(lblDelimiter).right(new FormAttachment(50, -5)).thenBelow((Control)cmbEncoding).label(lblEncoding).right(new FormAttachment(50, -5));
        FormDataFactory.startingWith((Control)extractor.getCombo()).thenRight((Control)button);
        FormDataFactory.startingWith((Control)delimiter.getCombo()).thenRight((Control)lblSkipLines).suffix((Control)skipLines);
        FormDataFactory.startingWith((Control)cmbEncoding).thenRight((Control)firstLineIsHeader);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)cmbEncoding, 10);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        data.width = 100;
        data.height = 100;
        compositeTable.setLayoutData((Object)data);
        TableColumnLayout layout = new TableColumnLayout();
        compositeTable.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(compositeTable, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ImportLabelProvider(this.importer));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        table.addMouseListener(MouseListener.mouseDoubleClickAdapter(e -> {
            TableItem item = table.getItem(0);
            if (item == null) {
                return;
            }
            int columnIndex = -1;
            int ii = 0;
            while (ii < table.getColumnCount()) {
                Rectangle bounds = item.getBounds(ii);
                int w = table.getColumn(ii).getWidth();
                if (e.x >= bounds.x && e.x <= bounds.x + w) {
                    columnIndex = ii;
                }
                ++ii;
            }
            if (columnIndex >= 0) {
                this.onColumnSelected(columnIndex);
            }
        }));
        this.doProcessFile();
    }

    private ComboViewer createExtractorComboViewer(Composite container) {
        Combo cmbExtractor = new Combo(container, 8);
        ComboViewer extractor = new ComboViewer(cmbExtractor);
        extractor.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        extractor.setInput((Object)this.importer.getExtractors());
        extractor.getCombo().setEnabled(!this.onlySecurityPrices);
        extractor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Extractor)element).getLabel();
            }
        });
        IViewerObservableValue targetObservable = ViewerProperties.singleSelection().observe((Viewer)extractor);
        IObservableValue modelObservable = BeanProperties.value((String)"extractor").observe((Object)this.importer);
        this.context.bindValue((IObservableValue)targetObservable, modelObservable);
        extractor.addSelectionChangedListener(e -> this.onTargetChanged());
        return extractor;
    }

    private ComboViewer createDelimiterComboViewer(Composite container) {
        Combo cmbDelimiter = new Combo(container, 8);
        ComboViewer delimiter = new ComboViewer(cmbDelimiter);
        delimiter.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        delimiter.setInput(Delimiter.AVAILABLE);
        UpdateValueStrategy targetToModel = new UpdateValueStrategy();
        targetToModel.setConverter((IConverter)new Delimiter.DelimiterToCharConverter());
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new Delimiter.CharToDelimiterConverter());
        IViewerObservableValue delimiterTarget = ViewerProperties.singleSelection(Delimiter.class).observe((Viewer)delimiter);
        IObservableValue delimiterModel = BeanProperties.value((String)"delimiter", Character.class).observe((Object)this.importer);
        this.context.bindValue((IObservableValue)delimiterTarget, delimiterModel, targetToModel, modelToTarget);
        delimiter.addSelectionChangedListener(e -> this.doProcessFile());
        return delimiter;
    }

    private void onTargetChanged() {
        CSVConfig config = new CSVConfig();
        config.readFrom(this.importer);
        config.writeTo(this.importer);
        this.doProcessFile(false);
    }

    private void onColumnSelected(int columnIndex) {
        ColumnConfigDialog dialog = new ColumnConfigDialog(this.client, this.getShell(), this.importer, this.importer.getColumns()[columnIndex]);
        dialog.open();
        this.doUpdateTable();
    }

    private void onConfigurationDropDown(Button button) {
        if (this.configurationDropDownMenu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(manager -> {
                if (this.currentConfigLabel != null) {
                    manager.add((IAction)new SimpleAction(Messages.CSVConfigRereadColumnsFromFile, a -> this.onRereadColumns()));
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new LabelOnly(Messages.CSVConfigLabelBuiltIn));
                this.configManager.getBuiltInConfigurations().forEach(config -> manager.add((IAction)new SimpleAction(this.labelFor((CSVConfig)config), a -> this.onConfigSelected((CSVConfig)config))));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new LabelOnly(Messages.CSVConfigLabelUserSpecific));
                this.configManager.getUserSpecificConfigurations().forEach(config -> manager.add((IAction)new SimpleAction(this.labelFor((CSVConfig)config), a -> this.onConfigSelected((CSVConfig)config))));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SimpleAction(Messages.CSVConfigSave, a -> this.onConfigSaved()));
                MenuManager subMenu = new MenuManager(Messages.CSVConfigDelete);
                manager.add((IContributionItem)subMenu);
                manager.add((IContributionItem)new Separator());
                this.configManager.getUserSpecificConfigurations().forEach(config -> subMenu.add((IAction)new SimpleAction(config.getLabel(), a -> this.onConfigDeleted((CSVConfig)config))));
                manager.add((IAction)new SimpleAction(Messages.CSVConfigExport, a -> this.onConfigExport()));
                manager.add((IAction)new SimpleAction(Messages.CSVConfigImport, a -> this.onConfigImport()));
            });
            this.configurationDropDownMenu = menuMgr.createContextMenu((Control)button);
            button.addDisposeListener(e -> this.configurationDropDownMenu.dispose());
        }
        this.configurationDropDownMenu.setVisible(true);
    }

    private String labelFor(CSVConfig config) {
        Optional extractor = this.importer.getExtractorByCode(config.getTarget());
        return extractor.isPresent() ? String.valueOf(config.getLabel()) + " (" + ((CSVExtractor)extractor.get()).getLabel() + ")" : config.getLabel();
    }

    private void onRereadColumns() {
        this.currentConfigLabel = null;
        this.doProcessFile();
    }

    private void onConfigSelected(CSVConfig config) {
        this.currentConfigLabel = config.getLabel();
        config.writeTo(this.importer);
        this.doProcessFile();
    }

    private void onConfigDeleted(CSVConfig config) {
        this.configManager.removeUserSpecificConfiguration(config);
        if (config.getLabel() == this.currentConfigLabel) {
            this.onRereadColumns();
        }
    }

    private void onConfigSaved() {
        InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.CSVConfigDialogTitleSave, Messages.ColumnName, this.currentConfigLabel != null ? this.currentConfigLabel : null, null);
        if (dlg.open() != 0) {
            return;
        }
        CSVConfig config = new CSVConfig();
        config.setLabel(dlg.getValue());
        config.readFrom(this.importer);
        this.configManager.addUserSpecificConfiguration(config);
        this.currentConfigLabel = config.getLabel();
    }

    private void onConfigExport() {
        FileDialog dialog = new FileDialog(this.getControl().getShell(), 8192);
        String proposal = TextUtil.sanitizeFilename((String)(this.currentConfigLabel != null ? this.currentConfigLabel : "csv-config"));
        dialog.setFileName(String.valueOf(proposal) + ".json");
        dialog.setOverwrite(true);
        String fileName = dialog.open();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                CSVConfig config = new CSVConfig();
                config.setLabel(this.currentConfigLabel != null ? this.currentConfigLabel : file.getName());
                config.readFrom(this.importer);
                JSONValue.writeJSONString((Object)config.toJSON(), (Writer)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)this.getControl().getShell(), (String)Messages.ExportWizardErrorExporting, (String)e.getMessage());
        }
    }

    private void onConfigImport() {
        FileDialog fileDialog = new FileDialog(this.getControl().getShell(), 4096);
        fileDialog.setFilterNames(new String[]{Messages.CSVConfigCSVImportLabelFileJSON, Messages.CSVImportLabelFileAll});
        fileDialog.setFilterExtensions(new String[]{"*.json", "*.*"});
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((Reader)reader);
                CSVConfig config = new CSVConfig();
                config.fromJSON(jsonObject);
                this.configManager.addUserSpecificConfiguration(config);
                this.onConfigSelected(config);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)this.getControl().getShell(), (String)Messages.ExportWizardErrorExporting, (String)e.getMessage());
        }
    }

    private void doProcessFile() {
        this.doProcessFile(this.currentConfigLabel == null);
    }

    private void doProcessFile(boolean remap) {
        try {
            try {
                this.importer.processFile(remap);
                this.tableViewer.getTable().setRedraw(false);
                TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.dispose();
                    ++n2;
                }
                TableColumnLayout layout = (TableColumnLayout)this.tableViewer.getTable().getParent().getLayout();
                CSVImporter.Column[] columnArray = this.importer.getColumns();
                int n3 = columnArray.length;
                n = 0;
                while (n < n3) {
                    CSVImporter.Column column = columnArray[n];
                    TableColumn tableColumn = new TableColumn(this.tableViewer.getTable(), 0);
                    layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(80, true));
                    this.setColumnLabel(tableColumn, column);
                    ++n;
                }
                ArrayList<CSVImporter> input = new ArrayList<CSVImporter>();
                input.add(this.importer);
                input.addAll(this.importer.getRawValues());
                this.tableViewer.setInput(input);
                this.tableViewer.refresh();
                this.tableViewer.getTable().pack();
                if (!Platform.getWS().equals("gtk")) {
                    TableColumn[] tableColumnArray2 = this.tableViewer.getTable().getColumns();
                    int n4 = tableColumnArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        TableColumn column = tableColumnArray2[n3];
                        column.pack();
                        ++n3;
                    }
                }
                this.doUpdateErrorMessages();
            }
            catch (IOException e) {
                PortfolioPlugin.log(e);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.LabelError, (String)e.getMessage(), (IStatus)new Status(4, "name.abuchen.portfolio.ui", e.getMessage(), (Throwable)e));
                this.tableViewer.getTable().setRedraw(true);
            }
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    private void setColumnLabel(TableColumn tableColumn, CSVImporter.Column column) {
        tableColumn.setText(column.getLabel());
        tableColumn.setAlignment(column.getField() instanceof CSVImporter.AmountField ? 131072 : 16384);
    }

    private void doUpdateTable() {
        Table table = this.tableViewer.getTable();
        table.setRedraw(false);
        try {
            int ii = 0;
            while (ii < table.getColumnCount()) {
                this.setColumnLabel(table.getColumn(ii), this.importer.getColumns()[ii]);
                ++ii;
            }
            this.tableViewer.refresh();
            this.doUpdateErrorMessages();
        }
        finally {
            table.setRedraw(true);
        }
    }

    private void doUpdateErrorMessages() {
        HashSet fieldsToMap = new HashSet(this.importer.getExtractor().getFields());
        CSVImporter.Column[] columnArray = this.importer.getColumns();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            CSVImporter.Column column = columnArray[n2];
            fieldsToMap.remove(column.getField());
            ++n2;
        }
        if (fieldsToMap.isEmpty()) {
            this.setMessage(null);
            this.setPageComplete(true);
        } else {
            String required = fieldsToMap.stream().filter(f -> !f.isOptional()).map(CSVImporter.Field::getName).collect(Collectors.joining(", "));
            String optional = fieldsToMap.stream().filter(CSVImporter.Field::isOptional).map(CSVImporter.Field::getName).collect(Collectors.joining(", "));
            boolean onlyOptional = required.length() == 0;
            this.setPageComplete(onlyOptional);
            StringBuilder message = new StringBuilder();
            if (required.length() > 0) {
                message.append(MessageFormat.format(Messages.CSVImportErrorMissingFields, required)).append("\n");
            }
            if (optional.length() > 0) {
                message.append(MessageFormat.format(Messages.CSVImportInformationOptionalFields, optional));
            }
            this.setMessage(message.toString(), onlyOptional ? 1 : 3);
        }
    }

    private static class ColumnConfigDialog
    extends Dialog
    implements ISelectionChangedListener {
        private static final CSVImporter.Field EMPTY = new CSVImporter.Field("#", new String[]{"---"});
        private CSVImporter importer;
        private CSVImporter.Column column;
        private final Client client;

        protected ColumnConfigDialog(Client client, Shell parentShell, CSVImporter importer, CSVImporter.Column column) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            this.client = client;
            this.importer = importer;
            this.column = column;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.CSVImportLabelEditMapping);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 0);
            label.setText(Messages.CSVImportLabelEditMapping);
            ComboViewer mappedTo = new ComboViewer(composite, 8);
            mappedTo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ArrayList<CSVImporter.Field> fields = new ArrayList<CSVImporter.Field>();
            fields.add(EMPTY);
            fields.addAll(this.importer.getExtractor().getFields());
            mappedTo.setInput(fields);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(mappedTo.getControl());
            final Composite details = new Composite(composite, 0);
            final StackLayout layout = new StackLayout();
            details.setLayout((Layout)layout);
            final Composite emptyArea = new Composite(details, 0);
            GridLayoutFactory glf = GridLayoutFactory.fillDefaults().margins(0, 0);
            final Composite dateArea = new Composite(details, 0);
            glf.applyTo(dateArea);
            label = new Label(dateArea, 0);
            label.setText(Messages.CSVImportLabelFormat);
            final ComboViewer dateFormats = new ComboViewer(dateArea, 8);
            dateFormats.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            dateFormats.getCombo().select(0);
            dateFormats.addSelectionChangedListener((ISelectionChangedListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(dateFormats.getControl());
            final Composite valueArea = new Composite(details, 0);
            glf.applyTo(valueArea);
            label = new Label(valueArea, 0);
            label.setText(Messages.CSVImportLabelFormat);
            final ComboViewer valueFormats = new ComboViewer(valueArea, 8);
            valueFormats.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            valueFormats.getCombo().select(0);
            valueFormats.addSelectionChangedListener((ISelectionChangedListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(valueFormats.getControl());
            final Composite keyArea = new Composite(details, 0);
            glf.applyTo(keyArea);
            final TableViewer tableViewer = new TableViewer(keyArea, 65536);
            tableViewer.setContentProvider((IContentProvider)new KeyMappingContentProvider());
            tableViewer.getTable().setLinesVisible(true);
            tableViewer.getTable().setHeaderVisible(true);
            GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 100).applyTo((Control)tableViewer.getTable());
            TableViewerColumn col = new TableViewerColumn(tableViewer, 0);
            col.getColumn().setText(Messages.CSVImportLabelExpectedValue);
            col.getColumn().setWidth(100);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((KeyMappingContentProvider.Entry)element).getKey();
                }
            });
            col = new TableViewerColumn(tableViewer, 0);
            col.getColumn().setText(Messages.CSVImportLabelProvidedValue);
            col.getColumn().setWidth(100);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((KeyMappingContentProvider.Entry)element).getValue();
                }
            });
            ColumnEditingSupport.prepare((ColumnViewer)tableViewer);
            col.setEditingSupport((EditingSupport)new ColumnEditingSupportWrapper((ColumnViewer)tableViewer, new StringEditingSupport(KeyMappingContentProvider.Entry.class, "value")));
            layout.topControl = emptyArea;
            mappedTo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CSVImporter.Field field = (CSVImporter.Field)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (field != column.getField()) {
                        column.setField((CSVImporter.Field)(field != EMPTY ? field : null));
                    }
                    if (field instanceof CSVImporter.DateField) {
                        layout.topControl = dateArea;
                        dateFormats.setInput((Object)field.getAvailableFieldFormats());
                        if (column.getFormat() != null) {
                            dateFormats.setSelection((ISelection)new StructuredSelection((Object)column.getFormat()));
                        } else {
                            dateFormats.setSelection((ISelection)new StructuredSelection((Object)field.guessFormat(client, importer.getFirstNonEmptyValue(column))));
                        }
                    } else if (field instanceof CSVImporter.AmountField) {
                        layout.topControl = valueArea;
                        valueFormats.setInput((Object)field.getAvailableFieldFormats());
                        if (column.getFormat() != null) {
                            valueFormats.setSelection((ISelection)new StructuredSelection((Object)column.getFormat()));
                        } else {
                            valueFormats.setSelection((ISelection)new StructuredSelection((Object)field.guessFormat(client, importer.getFirstNonEmptyValue(column))));
                        }
                    } else if (field instanceof CSVImporter.ISINField) {
                        column.setFormat(field.guessFormat(client, importer.getFirstNonEmptyValue(column)));
                    } else if (field instanceof CSVImporter.EnumField) {
                        layout.topControl = keyArea;
                        CSVImporter.FieldFormat f = column.getFormat();
                        if (f == null || !(f.getFormat() instanceof CSVImporter.EnumMapFormat)) {
                            f = field.guessFormat(client, null);
                            column.setFormat(f);
                        }
                        tableViewer.setInput((Object)((CSVImporter.EnumMapFormat)f.getFormat()));
                    } else {
                        layout.topControl = emptyArea;
                    }
                    details.layout();
                }
            });
            if (this.column.getField() != null) {
                mappedTo.setSelection((ISelection)new StructuredSelection((Object)this.column.getField()));
            } else {
                mappedTo.getCombo().select(0);
            }
            return composite;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            CSVImporter.FieldFormat format = (CSVImporter.FieldFormat)((IStructuredSelection)event.getSelectionProvider().getSelection()).getFirstElement();
            this.column.setFormat((CSVImporter.FieldFormat)(format != null ? format : null));
        }
    }

    private static final class ImportLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private static final Color GREEN = Colors.getColor(163, 215, 113);
        private static final Color LIGHTGREEN = Colors.getColor(188, 226, 158);
        private static final Color ERROR = Colors.getColor(255, 152, 89);
        private CSVImporter importer;
        private final LocalResourceManager resources;

        private ImportLabelProvider(CSVImporter importer) {
            this.importer = importer;
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }

        public void dispose() {
            this.resources.dispose();
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CSVImporter) {
                CSVImporter.Column column = this.importer.getColumns()[columnIndex];
                if (column.getField() == null) {
                    return Messages.CSVImportLabelDoubleClickHere;
                }
                return MessageFormat.format(Messages.CSVImportLabelMappedToField, column.getField().getName());
            }
            String[] line = (String[])element;
            if (line != null && columnIndex < line.length) {
                return line[columnIndex];
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return element instanceof CSVImporter ? Display.getDefault().getSystemColor(16) : null;
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof CSVImporter) {
                return null;
            }
            CSVImporter.Column column = this.importer.getColumns()[columnIndex];
            if (column.getField() == null) {
                return null;
            }
            try {
                String text;
                if (column.getFormat() != null && (text = this.getColumnText(element, columnIndex)) != null && !text.isEmpty()) {
                    column.getFormat().getFormat().parseObject(TextUtil.stripNonNumberCharacters((String)text));
                    return GREEN;
                }
                return column.getField().isOptional() ? LIGHTGREEN : GREEN;
            }
            catch (java.text.ParseException e) {
                return column.getField().isOptional() ? Colors.theme().warningBackground() : ERROR;
            }
        }
    }

    private static class KeyMappingContentProvider
    implements IStructuredContentProvider {
        private CSVImporter.EnumMapFormat<?> mapFormat;

        private KeyMappingContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mapFormat = (CSVImporter.EnumMapFormat)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.mapFormat == null) {
                return new Object[0];
            }
            ArrayList<Entry<Enum>> elements = new ArrayList<Entry<Enum>>();
            for (Enum entry : this.mapFormat.map().keySet()) {
                elements.add(new Entry<Enum>(this.mapFormat.map(), entry));
            }
            Collections.sort(elements, (e1, e2) -> ((Enum)e1.key).name().compareToIgnoreCase(((Enum)e2.key).name()));
            return elements.toArray();
        }

        public void dispose() {
        }

        public static final class Entry<M extends Enum<M>> {
            private EnumMap<M, String> map;
            private M key;

            private Entry(EnumMap<M, String> map, M key) {
                this.map = map;
                this.key = key;
            }

            public String getKey() {
                return ((Enum)this.key).toString();
            }

            public String getValue() {
                return this.map.get(this.key);
            }

            public void setValue(String value) {
                this.map.put(this.key, value);
            }

            static /* synthetic */ Enum access$0(Entry entry) {
                return entry.key;
            }
        }
    }
}

