/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import java.util.ArrayList;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NewPortfolioAccountPage
extends AbstractWizardPage {
    private Client client;

    public NewPortfolioAccountPage(Client client) {
        super(NewPortfolioAccountPage.class.getSimpleName());
        this.client = client;
        this.setTitle(Messages.NewFileWizardPortfolioTitle);
        this.setDescription(Messages.NewFileWizardPortfolioDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(container);
        Label lblPort = new Label(container, 0);
        lblPort.setText(Messages.ColumnPortfolio);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblPort);
        final Text portfolioName = new Text(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)portfolioName);
        Label lblAcc = new Label(container, 0);
        lblAcc.setText(Messages.ColumnReferenceAccount);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lblAcc);
        final Text accountName = new Text(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)accountName);
        final ArrayList data = new ArrayList();
        Button button = new Button(container, 8);
        button.setText(Messages.NewFileWizardButtonAdd);
        GridDataFactory.fillDefaults().applyTo((Control)button);
        Composite tableContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().span(5, 1).grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        final TableViewer tViewer = new TableViewer(tableContainer);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String portName = portfolioName.getText();
                String acnName = accountName.getText();
                if (portName.length() > 0 && acnName.length() > 0) {
                    Account account = new Account();
                    account.setName(acnName);
                    account.setCurrencyCode(NewPortfolioAccountPage.this.client.getBaseCurrency());
                    Portfolio portfolio = new Portfolio();
                    portfolio.setName(portName);
                    portfolio.setReferenceAccount(account);
                    NewPortfolioAccountPage.this.client.addAccount(account);
                    NewPortfolioAccountPage.this.client.addPortfolio(portfolio);
                    data.add(new Pair(portName, acnName));
                    tViewer.refresh();
                    accountName.setText("");
                    portfolioName.setText("");
                    portfolioName.setFocus();
                    NewPortfolioAccountPage.this.setPageComplete(true);
                }
            }
        });
        Table table = tViewer.getTable();
        table.setEnabled(false);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        tViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tViewer.setInput(data);
        TableViewerColumn pCol = new TableViewerColumn(tViewer, 0);
        layout.setColumnData((Widget)pCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        pCol.getColumn().setText(Messages.ColumnPortfolio);
        pCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Pair)element).portfolio;
            }

            public Image getImage(Object element) {
                return Images.PORTFOLIO.image();
            }
        });
        TableViewerColumn aCol = new TableViewerColumn(tViewer, 0);
        layout.setColumnData((Widget)aCol.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        aCol.getColumn().setText(Messages.ColumnReferenceAccount);
        aCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Pair)element).account;
            }

            public Image getImage(Object element) {
                return Images.ACCOUNT.image();
            }
        });
        container.pack();
        this.setPageComplete(false);
    }

    class Pair {
        private final String portfolio;
        private final String account;

        public Pair(String p, String a) {
            this.portfolio = p;
            this.account = a;
        }
    }
}

