/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.client;

import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.client.BaseCurrencySelectionPage;
import name.abuchen.portfolio.ui.wizards.client.MarkSecurityAsIndexPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ClientMigrationDialog
extends WizardDialog {
    public ClientMigrationDialog(Shell parentShell, Client client) {
        super(parentShell, (IWizard)new MigrationWizard(client));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(1).setEnabled(false);
    }

    private static class MigrationWizard
    extends Wizard {
        private Client client;
        private BaseCurrencySelectionPage currencySelectionPage;
        private MarkSecurityAsIndexPage markSecuritiesPage;

        public MigrationWizard(Client client) {
            this.client = client;
        }

        public Image getDefaultPageImage() {
            return Images.BANNER.image();
        }

        public void addPages() {
            this.currencySelectionPage = new BaseCurrencySelectionPage(Messages.BaseCurrencySelectionPage_Title, Messages.BaseCurrencyMigrationPage_Description, Messages.BaseCurrencyMigrationPage_ExplanationIndividualCurrency);
            this.addPage((IWizardPage)this.currencySelectionPage);
            this.markSecuritiesPage = new MarkSecurityAsIndexPage(this.client);
            this.addPage((IWizardPage)this.markSecuritiesPage);
            AbstractWizardPage.attachPageListenerTo(this.getContainer());
        }

        public boolean performFinish() {
            CurrencyUnit currency = this.currencySelectionPage.getSelectedCurrency();
            if (!"EUR".equals(currency.getCurrencyCode())) {
                ClientFactory.setAllCurrencies((Client)this.client, (String)currency.getCurrencyCode());
            }
            this.markSecuritiesPage.getSelectedSecurities().forEach(s -> s.setCurrencyCode(null));
            return true;
        }
    }
}

