/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.NumberVerifyListener;
import name.abuchen.portfolio.ui.util.StringToCurrencyConverter;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyModel;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ExpectedReturnsAttachedModel
implements TaxonomyModel.AttachedModel {
    public static final String KEY_EXPECTED_RETURN = "expected-return:value";
    public static final String KEY_ER_IN_USE = "expected-return:in-use";
    private TaxonomyModel taxonomyModel;

    private int getExpectedReturnFor(TaxonomyNode node) {
        Integer expectedReturn = (Integer)node.getData(KEY_EXPECTED_RETURN);
        return expectedReturn == null ? 0 : expectedReturn;
    }

    private void setExpectedReturnFor(TaxonomyNode node, int expectedReturn) {
        node.setData(KEY_EXPECTED_RETURN, expectedReturn);
    }

    public boolean getIsERinUse(TaxonomyNode node) {
        Boolean inUse = (Boolean)node.getData(KEY_ER_IN_USE);
        return Boolean.TRUE.equals(inUse);
    }

    public void setIsERinUse(TaxonomyNode node, boolean isERinUse) {
        node.setData(KEY_ER_IN_USE, isERinUse);
    }

    @Override
    public void setup(TaxonomyModel model) {
        this.taxonomyModel = model;
    }

    public void onERModified(Object element, Object newValue, Object oldValue) {
        TaxonomyNode node = (TaxonomyNode)element;
        this.recalcExpectedReturns(node);
        this.taxonomyModel.fireTaxonomyModelChange(node);
        this.taxonomyModel.markDirty();
    }

    @Override
    public void addColumns(ShowHideColumnHelper columns) {
        Column column = new Column("expectedReturn", Messages.ColumnExpectedReturn, 131072, 100);
        column.setMenuLabel(Messages.ColumnExpectedReturn_MenuLabel);
        column.setDescription(Messages.ColumnExpectedReturn_Description);
        column.setLabelProvider((CellLabelProvider)new ExpectedReturnLabelProvider());
        EREditingSupport eres = new EREditingSupport();
        eres.addListener(this::onERModified).attachTo(column);
        column.setSorter(null);
        column.setVisible(false);
        columns.addColumn(column);
        this.calcFullERTree(this.taxonomyModel.getVirtualRootNode());
    }

    @Override
    public void recalculate(TaxonomyModel model) {
        this.calcFullERTree(model.getVirtualRootNode());
    }

    public void calcFullERTree(TaxonomyNode node) {
        node.getChildren().forEach(this::calcFullERTree);
        if (node.isAssignment() || !this.getIsERinUse(node)) {
            return;
        }
        for (TaxonomyNode child : node.getChildren()) {
            if (this.getIsERinUse(child)) continue;
            return;
        }
        this.setExpectedReturnFor(node, (int)Math.round(this.calcERForNode(node, false)));
    }

    private double calcERForNode(TaxonomyNode parent, boolean markChildrenAsUsed) {
        double portfolioER = 0.0;
        for (TaxonomyNode node : parent.getChildren()) {
            long base = node.getParent() == null ? node.getActual().getAmount() : node.getParent().getActual().getAmount();
            double pctOfCategory = (double)node.getActual().getAmount() / (double)base;
            portfolioER += pctOfCategory * (double)this.getExpectedReturnFor(node);
            if (!markChildrenAsUsed) continue;
            this.setIsERinUse(node, true);
        }
        return portfolioER;
    }

    public void recalcExpectedReturns(TaxonomyNode currentNode) {
        this.markParentER(currentNode);
        if (currentNode.getChildren().size() == 1 && currentNode.getChildren().get(0).isAssignment()) {
            this.setExpectedReturnFor(currentNode.getChildren().get(0), this.getExpectedReturnFor(currentNode));
            this.setIsERinUse(currentNode.getChildren().get(0), true);
        } else {
            this.markChildrenAsERUnused(currentNode);
        }
        this.calcFullERTree(currentNode);
    }

    private void markParentER(TaxonomyNode currentNode) {
        TaxonomyNode parent = currentNode.getParent();
        for (TaxonomyNode node : parent.getChildren()) {
            this.setIsERinUse(node, true);
        }
        this.setIsERinUse(parent, true);
        if (!parent.isRoot()) {
            this.markParentER(parent);
        }
    }

    private void markChildrenAsERUnused(TaxonomyNode currentNode) {
        for (TaxonomyNode child : currentNode.getChildren()) {
            this.setIsERinUse(child, false);
            if (child.getChildren() == null) continue;
            this.markChildrenAsERUnused(child);
        }
    }

    class EREditingSupport
    extends ColumnEditingSupport {
        private StringToCurrencyConverter stringToLong = new StringToCurrencyConverter(Values.WeightPercent, true);

        @Override
        public boolean canEdit(Object element) {
            return !ExpectedReturnsAttachedModel.this.taxonomyModel.getClassificationRootNode().equals(element);
        }

        @Override
        public CellEditor createEditor(Composite composite) {
            TextCellEditor textEditor = new TextCellEditor(composite);
            ((Text)textEditor.getControl()).setTextLimit(20);
            ((Text)textEditor.getControl()).addVerifyListener((VerifyListener)new NumberVerifyListener(true));
            return textEditor;
        }

        @Override
        public Object getValue(Object element) throws Exception {
            TaxonomyNode node = (TaxonomyNode)element;
            return Values.WeightPercent.format((Object)ExpectedReturnsAttachedModel.this.getExpectedReturnFor(node));
        }

        @Override
        public void setValue(Object element, Object value) throws Exception {
            TaxonomyNode node = (TaxonomyNode)element;
            String str = String.valueOf(value);
            if (str.length() > 0 && str.charAt(str.length() - 1) == '%') {
                str = str.substring(0, str.length() - 1);
            }
            Number newValue = this.stringToLong.convert(str);
            newValue = ((Number)newValue).intValue();
            Integer oldValue = ExpectedReturnsAttachedModel.this.getExpectedReturnFor(node);
            if (newValue != null) {
                ExpectedReturnsAttachedModel.this.setExpectedReturnFor(node, (Integer)newValue);
                ExpectedReturnsAttachedModel.this.setIsERinUse(node, true);
                this.notify(element, newValue, oldValue);
            }
        }
    }

    private final class ExpectedReturnLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private StyledString.Styler strikeoutStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.strikeout = true;
                textStyle.foreground = Display.getDefault().getSystemColor(15);
            }
        };

        private ExpectedReturnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            TaxonomyNode node = (TaxonomyNode)cell.getElement();
            String erText = Values.WeightPercent.format((Object)ExpectedReturnsAttachedModel.this.getExpectedReturnFor(node));
            StyledString styledString = new StyledString(erText, ExpectedReturnsAttachedModel.this.getIsERinUse(node) ? null : this.strikeoutStyler);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
        }

        public String getText(Object element) {
            TaxonomyNode node = (TaxonomyNode)element;
            String prefix = ExpectedReturnsAttachedModel.this.getIsERinUse(node) ? "" : "(unused) ";
            return String.valueOf(prefix) + Values.WeightPercent.format((Object)ExpectedReturnsAttachedModel.this.getExpectedReturnFor(node));
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getToolTipText(Object element) {
            TaxonomyNode node = (TaxonomyNode)element;
            if (ExpectedReturnsAttachedModel.this.taxonomyModel.getClassificationRootNode().equals(node)) {
                return Messages.ColumnExpectedReturn_Tooltip_TotalPortfolioReturn;
            }
            return ExpectedReturnsAttachedModel.this.getIsERinUse(node) ? Messages.ColumnExpectedReturn_Tooltip_InUse : Messages.ColumnExpectedReturn_Tooltip_NotInUse;
        }

        public Point getToolTipShift(Object object) {
            return new Point(0, 15);
        }
    }
}

