/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.taxonomy;

import com.ibm.icu.text.MessageFormat;
import java.beans.PropertyChangeListener;
import java.util.function.Function;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.views.taxonomy.RebalancingColoringRule;
import name.abuchen.portfolio.ui.views.taxonomy.TaxonomyNode;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DeltaPercentageIndicatorLabelProvider
extends OwnerDrawLabelProvider {
    private Function<Object, TaxonomyNode> nodeProvider;
    private RebalancingColoringRule coloring;

    public DeltaPercentageIndicatorLabelProvider(Control control, Client client, Function<Object, TaxonomyNode> nodeProvider) {
        this.nodeProvider = nodeProvider;
        this.coloring = new RebalancingColoringRule(client);
        PropertyChangeListener listener = evt -> {
            RebalancingColoringRule rebalancingColoringRule = this.coloring = new RebalancingColoringRule(client);
        };
        client.addPropertyChangeListener(listener);
        control.addDisposeListener(e -> client.removePropertyChangeListener(listener));
    }

    protected void measure(Event event, Object element) {
        event.setBounds(new Rectangle(0, 0, 80, 10));
    }

    protected void paint(Event event, Object element) {
        Data data = Data.from(this.nodeProvider.apply(element));
        if (data == null) {
            return;
        }
        boolean isColored = Math.abs(data.relativeDeviation) > (double)this.coloring.getRelativeThreshold() / 100.0 || Math.abs(data.absoluteDeviation) > (double)this.coloring.getAbsoluteThreshold() / 100.0;
        Color oldForeground = event.gc.getForeground();
        Rectangle bounds = this.getBounds(event.item, event.index);
        int center = bounds.width / 2;
        event.gc.setBackground(Colors.SIDEBAR_BACKGROUND_SELECTED);
        event.gc.fillRectangle(bounds.x + center - 1, bounds.y, 3, bounds.height);
        double absolute = Math.abs(data.relativeDeviation);
        event.gc.setBackground(isColored ? Colors.ICON_ORANGE : Colors.ICON_BLUE);
        int bar = Math.min(center, (int)Math.round(absolute * ((double)center / ((double)this.coloring.getBarLength() / 100.0))));
        if (data.relativeDeviation < 0.0) {
            event.gc.fillRectangle(bounds.x + center - bar, bounds.y + bounds.height / 2 - 2, bar, 5);
        } else {
            event.gc.fillRectangle(bounds.x + center, bounds.y + bounds.height / 2 - 2, bar, 5);
        }
        event.gc.setForeground(oldForeground);
    }

    protected void erase(Event event, Object element) {
    }

    private Rectangle getBounds(Widget widget, int index) {
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getBounds(index);
        }
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getBounds(index);
        }
        throw new IllegalArgumentException();
    }

    public String getToolTipText(Object element) {
        Data data = Data.from(this.nodeProvider.apply(element));
        if (data == null) {
            return null;
        }
        return MessageFormat.format((String)Messages.TooltipRebalancingIndicator, (Object[])new Object[]{this.coloring.getAbsoluteThreshold(), this.coloring.getRelativeThreshold(), Values.Amount.format((Object)(data.actualAmount - data.targetAmount)), Values.Percent2.format((Object)data.absoluteDeviation), Values.Amount.format((Object)data.totalAmount), Values.Percent2.format((Object)data.relativeDeviation), Values.Amount.format((Object)data.targetAmount)});
    }

    private static class Data {
        long totalAmount;
        long targetAmount;
        long actualAmount;
        double absoluteDeviation;
        double relativeDeviation;

        private Data() {
        }

        private static Data from(TaxonomyNode node) {
            if (node.getTarget() == null || node.getTarget().isZero()) {
                return null;
            }
            Data data = new Data();
            data.totalAmount = node.getRoot().getActual().getAmount();
            data.targetAmount = node.getTarget().getAmount();
            data.actualAmount = node.getActual().getAmount();
            data.absoluteDeviation = (double)(data.actualAmount - data.targetAmount) / (double)data.totalAmount;
            data.relativeDeviation = (double)data.actualAmount / (double)data.targetAmount - 1.0;
            return data;
        }
    }
}

