/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

class StartYearSelectionDropDown
extends DropDown
implements IMenuListener {
    private EarningsViewModel model;

    public StartYearSelectionDropDown(EarningsViewModel model) {
        super(StartYearSelectionDropDown.createLabelTextForYear(model.getStartYear()));
        this.model = model;
        this.setMenuListener(this);
    }

    public void menuAboutToShow(IMenuManager manager) {
        int now = LocalDate.now().getYear();
        int ii = 0;
        while (ii < 10) {
            final int year = now - ii;
            Action action = new Action(String.valueOf(year)){

                public void run() {
                    StartYearSelectionDropDown.this.model.updateWith(year);
                    StartYearSelectionDropDown.this.setLabel(StartYearSelectionDropDown.createLabelTextForYear(year));
                }
            };
            action.setChecked(year == this.model.getStartYear());
            manager.add((IAction)action);
            ++ii;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SimpleAction(Messages.LabelSelectYear, a -> {
            IInputValidator validator = newText -> {
                try {
                    int year = Integer.parseInt(newText);
                    return year >= 1900 && year <= now ? null : MessageFormat.format((String)Messages.MsgErrorDividendsYearBetween1900AndNow, (Object[])new Object[]{String.valueOf(now)});
                }
                catch (NumberFormatException nfe) {
                    return MessageFormat.format((String)Messages.MsgErrorDividendsYearBetween1900AndNow, (Object[])new Object[]{String.valueOf(now)});
                }
            };
            InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.LabelYear, Messages.LabelEarningsSelectStartYear, String.valueOf(this.model.getStartYear()), validator);
            if (dialog.open() == 0) {
                int year = Integer.parseInt(dialog.getValue());
                this.model.updateWith(year);
                this.setLabel(StartYearSelectionDropDown.createLabelTextForYear(year));
            }
        }));
    }

    private static String createLabelTextForYear(int year) {
        return String.valueOf(Messages.LabelSelectYearSince) + " " + year;
    }
}

