/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.earnings;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import name.abuchen.portfolio.ui.views.earnings.AbstractChartTab;
import name.abuchen.portfolio.ui.views.earnings.EarningsViewModel;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.swtchart.Chart;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class EarningsPerYearChartTab
extends AbstractChartTab {
    @Override
    public String getLabel() {
        return Messages.LabelEarningsPerYear;
    }

    @Override
    protected void attachTooltipTo(Chart chart) {
        DividendPerYearToolTip toolTip = new DividendPerYearToolTip(chart, this.model);
        toolTip.enableCategory(true);
    }

    private void updateCategorySeries() {
        int startYear = this.model.getStartYear();
        String[] labels = new String[LocalDate.now().getYear() - startYear + 1];
        int ii = 0;
        while (ii < labels.length) {
            labels[ii] = String.valueOf(startYear + ii);
            ++ii;
        }
        this.getChart().getAxisSet().getXAxis(0).setCategorySeries(labels);
    }

    @Override
    protected void createSeries() {
        int year;
        this.updateCategorySeries();
        int startYear = this.model.getStartYear();
        double[] series = new double[LocalDate.now().getYear() - startYear + 1];
        boolean hasNegativeNumber = false;
        int index = 0;
        while (index < this.model.getNoOfMonths()) {
            year = index / 12;
            long total = 0L;
            int months = Math.min(12, this.model.getNoOfMonths() - index);
            int ii = 0;
            while (ii < months) {
                total += this.model.getSum().getValue(index + ii);
                ++ii;
            }
            series[year] = (double)total / Values.Amount.divider();
            if (total < 0L) {
                hasNegativeNumber = true;
            }
            index += 12;
        }
        if (hasNegativeNumber) {
            IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, this.getLabel());
            barSeries.setYSeries(series);
            barSeries.setBarColor(Colors.DARK_BLUE);
        } else {
            int i = 0;
            while (i < series.length) {
                year = this.model.getStartYear() + i;
                IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, String.valueOf(year));
                double[] seriesX = new double[LocalDate.now().getYear() - startYear + 1];
                seriesX[i] = series[i];
                barSeries.setYSeries(seriesX);
                barSeries.setBarColor(this.getColor(year));
                barSeries.setBarPadding(25);
                barSeries.enableStack(true);
                ++i;
            }
        }
    }

    private class DividendPerYearToolTip
    extends TimelineChartToolTip {
        private EarningsViewModel model;

        public DividendPerYearToolTip(Chart chart, EarningsViewModel model) {
            super(chart);
            this.model = model;
        }

        @Override
        protected void createComposite(Composite parent) {
            int year = (Integer)this.getFocusedObject();
            int totalNoOfMonths = this.model.getNoOfMonths();
            Color barColor = Colors.DARK_BLUE;
            IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().getSeries()[0];
            if (barSeries.isStackEnabled()) {
                barSeries = (IBarSeries)this.getChart().getSeriesSet().getSeries()[year];
                barColor = barSeries.getBarColor();
            }
            List<EarningsViewModel.Line> lines = this.model.getLines().stream().filter(line -> {
                int index = year * 12;
                while (index < (year + 1) * 12 && index < totalNoOfMonths) {
                    if (line.getValue(index) != 0L) {
                        return true;
                    }
                    ++index;
                }
                return false;
            }).sorted((l1, l2) -> l1.getVehicle().getName().compareToIgnoreCase(l2.getVehicle().getName())).collect(Collectors.toList());
            Composite container = new Composite(parent, 0);
            container.setBackgroundMode(2);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
            Label topLeft = new Label(container, 0);
            topLeft.setText(Messages.ColumnSecurity);
            ColoredLabel label = new ColoredLabel(container, 0x1000000);
            label.setBackdropColor(barColor);
            label.setText(String.valueOf(this.model.getStartYear() + year));
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)label);
            lines.forEach(line -> {
                Label l = new Label(container, 0);
                l.setText(TextUtil.tooltip((String)line.getVehicle().getName()));
                long value = 0L;
                int m = year * 12;
                while (m < (year + 1) * 12 && m < totalNoOfMonths) {
                    value += line.getValue(m);
                    ++m;
                }
                l = new Label(container, 131072);
                l.setText(Values.Amount.format((Object)value));
                GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)l);
            });
            Label l = new Label(container, 0);
            l.setText(Messages.ColumnSum);
            long value = 0L;
            int m = year * 12;
            while (m < (year + 1) * 12 && m < totalNoOfMonths) {
                value += this.model.getSum().getValue(m);
                ++m;
            }
            ColoredLabel cl = new ColoredLabel(container, 131072);
            cl.setBackdropColor(barColor);
            cl.setText(Values.Amount.format((Object)value));
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)cl);
        }
    }
}

