/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import name.abuchen.portfolio.snapshot.Aggregation;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.dataseries.AbstractChartSeriesBuilder;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.util.Interval;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;

public class PerformanceChartSeriesBuilder
extends AbstractChartSeriesBuilder {
    public PerformanceChartSeriesBuilder(TimelineChart chart, DataSeriesCache cache) {
        super(chart, cache);
    }

    public void build(DataSeries series, Interval reportingPeriod, Aggregation.Period aggregationPeriod) {
        PerformanceIndex index = this.getCache().lookup(series, reportingPeriod);
        if (series.getType() == DataSeries.Type.CLIENT) {
            this.addClient(series, index, aggregationPeriod);
        } else {
            if (aggregationPeriod != null) {
                index = Aggregation.aggregate((PerformanceIndex)index, (Aggregation.Period)aggregationPeriod);
            }
            ILineSeries lineSeries = this.getChart().addDateSeries(index.getDates(), index.getAccumulatedPercentage(), series.getLabel());
            this.configure(series, lineSeries);
        }
    }

    private void addClient(DataSeries series, PerformanceIndex clientIndex, Aggregation.Period aggregationPeriod) {
        PerformanceIndex index = aggregationPeriod != null ? Aggregation.aggregate((PerformanceIndex)clientIndex, (Aggregation.Period)aggregationPeriod) : clientIndex;
        switch ((DataSeries.ClientDataSeries)((Object)series.getInstance())) {
            case TOTALS: {
                ILineSeries lineSeries = this.getChart().addDateSeries(index.getDates(), index.getAccumulatedPercentage(), series.getLabel());
                this.configure(series, lineSeries);
                break;
            }
            case DELTA_PERCENTAGE: {
                String aggreagtionPeriodLabel = aggregationPeriod != null ? aggregationPeriod.toString() : Messages.LabelAggregationDaily;
                IBarSeries barSeries = this.getChart().addDateBarSeries(index.getDates(), index.getDeltaPercentage(), aggreagtionPeriodLabel);
                series.setLabel(aggreagtionPeriodLabel);
                this.configure(series, barSeries);
                break;
            }
        }
    }
}

