/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DataSeriesSelectionDialog
extends Dialog {
    private boolean isMultiSelection = true;
    private Node[] elements;
    private Object[] selected;
    private TreeViewer treeViewer;
    private ElementFilter elementFilter;
    private Text searchText;

    public DataSeriesSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setMultiSelection(boolean isMultiSelection) {
        this.isMultiSelection = isMultiSelection;
    }

    public void setElements(List<DataSeries> elements) {
        HashMap<String, Node> type2node = new HashMap<String, Node>();
        HashMap<Object, Node> group2node = new HashMap<Object, Node>();
        for (DataSeries series : elements) {
            Node child = new Node(series.getSearchLabel());
            child.dataSeries = series;
            Node parent = type2node.computeIfAbsent(this.map(series.getType()), Node::new);
            if (series.getGroup() != null) {
                Node group;
                child.parent = group = group2node.computeIfAbsent(series.getGroup(), g -> {
                    Node n = new Node(g.toString());
                    n.parent = parent;
                    node.children.add(n);
                    return n;
                });
                group.children.add(child);
                continue;
            }
            child.parent = parent;
            parent.children.add(child);
        }
        this.elements = type2node.values().toArray(new Node[0]);
    }

    private String map(DataSeries.Type type) {
        switch (type) {
            case SECURITY: {
                return Messages.LabelSecurities;
            }
            case SECURITY_BENCHMARK: {
                return Messages.LabelBenchmarks;
            }
            case CLASSIFICATION: {
                return Messages.LabelTaxonomies;
            }
            case CLIENT: 
            case CLIENT_PRETAX: {
                return Messages.LabelCommon;
            }
        }
        return Messages.LabelClientFilterDialogTitle;
    }

    public List<DataSeries> getResult() {
        ArrayList<DataSeries> result = new ArrayList<DataSeries>();
        Object[] objectArray = this.selected;
        int n = this.selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            Node n3 = (Node)node;
            if (n3.dataSeries != null) {
                result.add(n3.dataSeries);
            }
            ++n2;
        }
        return result;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setText(Messages.ChartSeriesPickerTitle);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 300).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Label label = new Label(container, 0);
        label.setText(Messages.ChartSeriesPickerTitle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.searchText = new Text(container, 896);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchText);
        this.searchText.setFocus();
        Composite treeArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)treeArea);
        treeArea.setLayout((Layout)new FillLayout());
        TreeColumnLayout layout = new TreeColumnLayout();
        treeArea.setLayout((Layout)layout);
        this.elementFilter = new ElementFilter();
        int style = 67584;
        if (this.isMultiSelection) {
            style |= 2;
        }
        this.treeViewer = new TreeViewer(treeArea, style);
        Tree table = this.treeViewer.getTree();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TreeViewerColumn column = new TreeViewerColumn(this.treeViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                Node node = (Node)element;
                return node.dataSeries != null ? node.dataSeries.getImage() : Images.UNASSIGNED_CATEGORY.image();
            }

            public String getText(Object element) {
                return ((Node)element).label;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new NodeContentProvider());
        this.treeViewer.addFilter((ViewerFilter)this.elementFilter);
        this.treeViewer.setInput((Object)this.elements);
        this.treeViewer.setComparator(new ViewerComparator());
        this.hookListener();
        this.treeViewer.expandAll();
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void hookListener() {
        this.treeViewer.addSelectionChangedListener(event -> {
            this.selected = ((IStructuredSelection)event.getSelection()).toArray();
            this.getButton(0).setEnabled(!this.getResult().isEmpty());
        });
        this.treeViewer.addDoubleClickListener(event -> {
            this.selected = ((IStructuredSelection)event.getSelection()).toArray();
            if (!this.getResult().isEmpty()) {
                this.okPressed();
            }
        });
        this.searchText.addModifyListener(e -> {
            String pattern = this.searchText.getText().trim();
            if (pattern.length() == 0) {
                this.elementFilter.setSearchPattern(null);
            } else {
                this.elementFilter.setSearchPattern(pattern);
            }
            this.treeViewer.refresh();
        });
    }

    private class ElementFilter
    extends ViewerFilter {
        private Pattern filterPattern;

        private ElementFilter() {
        }

        public void setSearchPattern(String pattern) {
            this.filterPattern = pattern != null ? Pattern.compile(".*" + pattern + ".*", 2) : null;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.filterPattern == null) {
                return true;
            }
            Node node = (Node)element;
            if (!node.children.isEmpty()) {
                return true;
            }
            return this.filterPattern.matcher(node.label).matches();
        }
    }

    private static class Node {
        private Node parent;
        private List<Node> children = new ArrayList<Node>();
        private String label;
        private DataSeries dataSeries;

        public Node(String label) {
            this.label = label;
        }
    }

    private static class NodeContentProvider
    implements ITreeContentProvider {
        private NodeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Node[]) {
                return (Node[])inputElement;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            Node parent = (Node)parentElement;
            return parent.children.toArray();
        }

        public Object getParent(Object element) {
            return ((Node)element).parent;
        }

        public boolean hasChildren(Object element) {
            return !((Node)element).children.isEmpty();
        }
    }
}

