/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import name.abuchen.portfolio.money.Values;

public class HeatmapModel<N extends Number> {
    private Values<N> formatter;
    private List<Header> header = new ArrayList<Header>();
    private List<Row<N>> rows = new ArrayList<Row<N>>();
    private Function<N, String> toolTipBuilder;

    public HeatmapModel(Values<N> formatter) {
        this.formatter = formatter;
    }

    public void addHeader(String label) {
        this.addHeader(label, null);
    }

    public void addHeader(String label, String toolTip) {
        this.header.add(new Header(label, toolTip));
    }

    public Stream<Header> getHeader() {
        return this.header.stream();
    }

    public int getHeaderSize() {
        return this.header.size();
    }

    public void addRow(Row<N> row) {
        this.rows.add(row);
    }

    public Row<N> getRow(int index) {
        return this.rows.get(index);
    }

    public Stream<Row<N>> getRows() {
        return this.rows.stream();
    }

    public List<N> getColumnValues(int index) {
        ArrayList<Number> values = new ArrayList<Number>();
        for (Row<N> row : this.rows) {
            Number v = (Number)row.getData(index);
            if (v == null) continue;
            values.add(v);
        }
        return values;
    }

    public Function<N, String> getCellToolTip() {
        return this.toolTipBuilder;
    }

    public void setCellToolTip(Function<N, String> toolTipBuilder) {
        this.toolTipBuilder = toolTipBuilder;
    }

    public Values<N> getFormatter() {
        return this.formatter;
    }

    public static class Header {
        private String label;
        private String toolTip;

        public Header(String label, String toolTip) {
            this.label = label;
            this.toolTip = toolTip;
        }

        public String getLabel() {
            return this.label;
        }

        public String getToolTip() {
            return this.toolTip;
        }
    }

    public static class Row<N> {
        private String label;
        private String toolTip;
        private List<N> data = new ArrayList<N>();

        public Row(String label) {
            this(label, null);
        }

        public Row(String label, String toolTip) {
            this.label = label;
            this.toolTip = toolTip;
        }

        public String getLabel() {
            return this.label;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public void addData(N value) {
            this.data.add(value);
        }

        public void setData(int index, N value) {
            this.data.set(index, value);
        }

        public N getData(int index) {
            return this.data.get(index);
        }

        public Stream<N> getData() {
            return this.data.stream();
        }

        public List<N> getDataSubList(int fromIndex, int toIndex) {
            return this.data.subList(fromIndex, toIndex);
        }
    }
}

