/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.time.LocalDate;
import java.time.Year;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dashboard.ClientFilterConfig;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.EnumBasedConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.AbstractHeatmapWidget;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapModel;
import name.abuchen.portfolio.util.Interval;

public class EarningsHeatmapWidget
extends AbstractHeatmapWidget<Long> {
    public EarningsHeatmapWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ClientFilterConfig(this));
        this.addConfig(new EarningsConfig(this));
        this.addConfig(new GrossNetConfig(this));
        this.addConfig(new AverageConfig(this));
    }

    @Override
    protected HeatmapModel<Long> build() {
        int numDashboardColumns = this.getDashboardData().getDashboard().getColumns().size();
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
        Interval calcInterval = Interval.of((LocalDate)(interval.getStart().getDayOfMonth() == interval.getStart().lengthOfMonth() ? interval.getStart() : interval.getStart().withDayOfMonth(1).minusDays(1L)), (LocalDate)interval.getEnd().withDayOfMonth(interval.getEnd().lengthOfMonth()));
        HeatmapModel<Long> model = new HeatmapModel<Long>(numDashboardColumns <= 1 ? Values.Amount : Values.AmountShort);
        model.setCellToolTip(value -> value != null ? Values.Amount.format(value) : "");
        boolean showAverage = this.get(AverageConfig.class).getValues().contains((Object)Average.AVERAGE);
        this.addMonthlyHeader(model, numDashboardColumns, true, false, showAverage);
        int startYear = calcInterval.getStart().plusDays(1L).getYear();
        for (Year year : calcInterval.getYears()) {
            String label = numDashboardColumns > 2 ? String.valueOf(year.getValue() % 100) : String.valueOf(year);
            HeatmapModel.Row<Long> row2 = new HeatmapModel.Row<Long>(label);
            LocalDate month = LocalDate.of(year.getValue(), 1, 1);
            while (month.getYear() == year.getValue()) {
                row2.addData(calcInterval.contains(month) ? Long.valueOf(0L) : null);
                month = month.plusMonths(1L);
            }
            model.addRow(row2);
        }
        CurrencyConverter converter = this.getDashboardData().getCurrencyConverter();
        EarningType type = (EarningType)((Object)this.get(EarningsConfig.class).getValue());
        GrossNetType grossNet = (GrossNetType)((Object)this.get(GrossNetConfig.class).getValue());
        Client filteredClient = this.get(ClientFilterConfig.class).getSelectedFilter().filter(this.getDashboardData().getClient());
        filteredClient.getAccounts().stream().flatMap(a -> a.getTransactions().stream()).filter(type::isIncluded).filter(t -> calcInterval.contains(t.getDateTime())).forEach(t -> {
            int row = t.getDateTime().getYear() - startYear;
            int col = t.getDateTime().getMonth().getValue() - 1;
            Long value = converter.convert(t.getDateTime(), grossNet.getValue((AccountTransaction)t)).getAmount();
            if (t.getType().isDebit()) {
                value = -value.longValue();
            }
            Long oldValue = (Long)model.getRow(row).getData(col);
            model.getRow(row).setData(col, oldValue + value);
        });
        model.getRows().forEach(row -> row.addData(row.getData().mapToLong(l -> l == null ? 0L : l).sum()));
        if (showAverage) {
            model.getRows().forEach(row -> row.addData((long)row.getDataSubList(0, 12).stream().filter(Objects::nonNull).mapToLong(l -> l == null ? 0L : l).average().getAsDouble()));
        }
        return model;
    }

    public static enum Average {
        AVERAGE(Messages.HeatmapOrnamentAverage);

        private String label;

        private Average(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    static class AverageConfig
    extends EnumBasedConfig<Average> {
        public AverageConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.HeatmapOrnamentAverage, Average.class, Dashboard.Config.LAYOUT, EnumBasedConfig.Policy.MULTIPLE);
        }
    }

    static enum EarningType {
        EARNINGS(String.valueOf(Messages.LabelDividends) + " + " + Messages.LabelInterest, t -> t.getType() == AccountTransaction.Type.DIVIDENDS || t.getType() == AccountTransaction.Type.INTEREST || t.getType() == AccountTransaction.Type.INTEREST_CHARGE),
        DIVIDENDS(Messages.LabelDividends, t -> t.getType() == AccountTransaction.Type.DIVIDENDS),
        INTEREST(Messages.LabelInterest, t -> t.getType() == AccountTransaction.Type.INTEREST || t.getType() == AccountTransaction.Type.INTEREST_CHARGE);

        private String label;
        private Predicate<AccountTransaction> predicate;

        private EarningType(String label, Predicate<AccountTransaction> predicate) {
            this.label = label;
            this.predicate = predicate;
        }

        public String toString() {
            return this.label;
        }

        public boolean isIncluded(AccountTransaction t) {
            return this.predicate.test(t);
        }
    }

    static class EarningsConfig
    extends EnumBasedConfig<EarningType> {
        public EarningsConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.LabelEarnings, EarningType.class, Dashboard.Config.EARNING_TYPE, EnumBasedConfig.Policy.EXACTLY_ONE);
        }
    }

    static class GrossNetConfig
    extends EnumBasedConfig<GrossNetType> {
        public GrossNetConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.LabelGrossNetCalculation, GrossNetType.class, Dashboard.Config.NET_GROSS, EnumBasedConfig.Policy.EXACTLY_ONE);
        }
    }

    static enum GrossNetType {
        NET(Messages.LabelNet, t -> t.getMonetaryAmount()),
        GROSS(Messages.LabelGross, t -> t.getGrossValue());

        private String label;
        private Function<AccountTransaction, Money> valueExtractor;

        private GrossNetType(String label, Function<AccountTransaction, Money> valueExtractor) {
            this.label = label;
            this.valueExtractor = valueExtractor;
        }

        public String toString() {
            return this.label;
        }

        public Money getValue(AccountTransaction t) {
            return this.valueExtractor.apply(t);
        }
    }
}

