/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.util.function.DoubleFunction;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

enum ColorSchema {
    GREEN_YELLOW_RED(Messages.LabelGreenYellowRed),
    GREEN_WHITE_RED(Messages.LabelGreenWhiteRed);

    private String label;

    private ColorSchema(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    DoubleFunction<Color> buildColorFunction(ResourceManager resourceManager) {
        switch (this) {
            case GREEN_YELLOW_RED: {
                return performance -> {
                    double max = 0.07f;
                    double p = performance;
                    p = Math.max((double)-0.07f, p);
                    p = Math.min((double)0.07f, p);
                    p = (p + (double)0.07f) * 7.14285711244661;
                    float hue = (float)p * 120.0f;
                    return resourceManager.createColor(new RGB(hue, 0.9f, 1.0f));
                };
            }
            case GREEN_WHITE_RED: {
                return performance -> {
                    double max = 0.07f;
                    double p = performance;
                    p = Math.min((double)0.07f, Math.abs(p));
                    RGB color = performance > 0.0 ? Colors.GREEN.getRGB() : Colors.RED.getRGB();
                    return resourceManager.createColor(Colors.interpolate(Colors.theme().defaultBackground().getRGB(), color, (float)(p /= (double)0.07f)));
                };
            }
        }
        throw new IllegalArgumentException();
    }
}

