/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.InfoToolTip;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ColorSchema;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ColorSchemaConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.EarningsHeatmapWidget;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapModel;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapOrnament;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.SimpleGridLayout;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractHeatmapWidget<N extends Number>
extends WidgetDelegate<HeatmapModel<N>> {
    private Composite table;
    private Label title;
    private DashboardResources resources;

    public AbstractHeatmapWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ReportingPeriodConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        this.resources = resources;
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        container.setBackground(parent.getBackground());
        this.title = new Label(container, 0);
        this.title.setBackground(container.getBackground());
        this.title.setText(this.getWidget().getLabel() != null ? TextUtil.tooltip((String)this.getWidget().getLabel()) : "");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title);
        this.table = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.table);
        this.table.setBackground(container.getBackground());
        return container;
    }

    protected abstract HeatmapModel<N> build();

    private void fillTable(HeatmapModel<N> model, Composite table, DashboardResources resources) {
        this.addHeaderRow(table, model);
        DoubleFunction coloring = this.optionallyGet(ColorSchemaConfig.class).map(s -> ((ColorSchema)((Object)((Object)s.getValue()))).buildColorFunction((ResourceManager)resources.getResourceManager())).orElse(null);
        Values formatter = model.getFormatter();
        model.getRows().forEach(row -> {
            Label label = new Label(table, 0x1000000);
            label.setBackground(table.getBackground());
            label.setText(row.getLabel());
            if (row.getToolTip() != null) {
                InfoToolTip.attach((Control)label, row.getToolTip());
            }
            row.getData().forEach(data -> {
                Object lbl = null;
                if (data != null) {
                    ColoredLabel dataLabel = new ColoredLabel(table, 0x1000000);
                    dataLabel.setFont(resources.getSmallFont());
                    dataLabel.setText(formatter.format(data));
                    if (coloring != null) {
                        dataLabel.setBackdropColor((Color)coloring.apply((Double)data));
                    }
                    lbl = dataLabel;
                } else {
                    lbl = new Label(table, 16384);
                }
                if (model.getCellToolTip() != null) {
                    InfoToolTip.attach((Control)lbl, model.getCellToolTip().apply(data));
                }
            });
        });
        SimpleGridLayout layout = new SimpleGridLayout();
        layout.setNumColumns(model.getHeaderSize() + 1);
        layout.setNumRows((int)model.getRows().count() + 1);
        layout.setRowHeight(SWTHelper.lineHeight((Control)table) + 6);
        table.setLayout((Layout)layout);
        table.layout(true);
    }

    private void addHeaderRow(Composite table, HeatmapModel<?> model) {
        Label topLeft = new Label(table, 0);
        topLeft.setBackground(table.getBackground());
        model.getHeader().forEach(header -> {
            CLabel l = new CLabel(table, 0x1000000);
            l.setText(header.getLabel());
            l.setBackground(table.getBackground());
            InfoToolTip.attach((Control)l, header.getToolTip() != null ? header.getToolTip() : header.getLabel());
        });
    }

    @Override
    public Supplier<HeatmapModel<N>> getUpdateTask() {
        return this::build;
    }

    @Override
    public void update(HeatmapModel<N> model) {
        this.title.setText(this.getWidget().getLabel() != null ? TextUtil.tooltip((String)this.getWidget().getLabel()) : "");
        Control[] controlArray = this.table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.fillTable(model, this.table, this.resources);
        this.table.getParent().getParent().layout(true);
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    protected void addMonthlyHeader(HeatmapModel<?> model, int numDashboardColumns, boolean showSum, boolean showStandardDeviation, boolean showAverage) {
        TextStyle textStyle = numDashboardColumns == 1 ? TextStyle.FULL : (numDashboardColumns == 2 ? TextStyle.SHORT : TextStyle.NARROW);
        LocalDate m = LocalDate.of(2016, 1, 1);
        while (m.getYear() == 2016) {
            model.addHeader(m.getMonth().getDisplayName(textStyle, Locale.getDefault()));
            m = m.plusMonths(1L);
        }
        if (showSum) {
            model.addHeader("\u03a3", HeatmapOrnament.SUM.toString());
        }
        if (showStandardDeviation) {
            model.addHeader("s", HeatmapOrnament.STANDARD_DEVIATION.toString());
        }
        if (showAverage) {
            model.addHeader("\u2300", EarningsHeatmapWidget.Average.AVERAGE.toString());
        }
    }

    protected Double geometricMean(List<Double> values) {
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        double sum = 1.0;
        for (Double v : values) {
            sum *= 1.0 + v;
        }
        return Math.pow(sum, 1.0 / (double)values.size()) - 1.0;
    }

    protected Double standardDeviation(List<Double> values) {
        int count = 0;
        double sum = 0.0;
        for (Double data : values) {
            if (data == null) continue;
            ++count;
            sum += data.doubleValue();
        }
        if (count == 0) {
            return null;
        }
        double mean = sum / (double)count;
        double deviationSquares = 0.0;
        for (Double data : values) {
            if (data == null) continue;
            deviationSquares += Math.pow(data - mean, 2.0);
        }
        return Math.sqrt(deviationSquares / (double)count);
    }
}

