/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MutableMoney;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientPerformanceSnapshot;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.DataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.EnumBasedConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PerformanceCalculationWidget
extends WidgetDelegate<ClientPerformanceSnapshot> {
    private Composite container;
    private DashboardResources resources;
    private Label title;
    private Label[] signs;
    private Label[] labels;
    private Label[] values;

    public PerformanceCalculationWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
        this.addConfig(new ReportingPeriodConfig(this));
        this.addConfig(new DataSeriesConfig(this, false));
        this.addConfig(new LayoutConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        this.resources = resources;
        this.container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).spacing(3, 3).applyTo(this.container);
        this.container.setBackground(parent.getBackground());
        this.title = new Label(this.container, 0);
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        this.title.setBackground(this.container.getBackground());
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.title);
        TableLayout layout = (TableLayout)((Object)this.get(LayoutConfig.class).getValue());
        this.createControls(layout);
        return this.container;
    }

    private void createControls(TableLayout layout) {
        this.title.setData((Object)layout);
        int count = ClientPerformanceSnapshot.CategoryType.values().length;
        switch (layout) {
            case FULL: {
                this.createTable(count);
                break;
            }
            case REDUCED: {
                this.createTable(5);
                break;
            }
            case RELEVANT: {
                this.createTable(8);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void createTable(int size) {
        Font boldFont = this.resources.getResourceManager().createFont(FontDescriptor.createFrom((Font)this.container.getFont()).setStyle(1));
        this.labels = new Label[size];
        this.signs = new Label[size];
        this.values = new Label[size];
        int ii = 0;
        while (ii < size) {
            this.signs[ii] = new Label(this.container, 0);
            this.signs[ii].setBackground(this.container.getBackground());
            this.labels[ii] = new Label(this.container, 0);
            this.labels[ii].setBackground(this.container.getBackground());
            this.values[ii] = new Label(this.container, 131072);
            this.values[ii].setBackground(this.container.getBackground());
            GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.values[ii]);
            if (ii == 0 || ii == size - 1) {
                this.signs[ii].setFont(boldFont);
                this.labels[ii].setFont(boldFont);
                this.values[ii].setFont(boldFont);
            }
            if (ii == 0 || ii == size - 2) {
                Label separator = new Label(this.container, 258);
                GridDataFactory.fillDefaults().span(3, 1).grab(true, false).align(4, 1).applyTo((Control)separator);
            }
            ++ii;
        }
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public Supplier<ClientPerformanceSnapshot> getUpdateTask() {
        return () -> {
            PerformanceIndex index = this.getDashboardData().calculate(this.get(DataSeriesConfig.class).getDataSeries(), this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now()));
            return (ClientPerformanceSnapshot)index.getClientPerformanceSnapshot().orElseThrow(IllegalArgumentException::new);
        };
    }

    @Override
    public void update(ClientPerformanceSnapshot snapshot) {
        TableLayout layout = (TableLayout)((Object)this.get(LayoutConfig.class).getValue());
        if (!layout.equals(this.title.getData())) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!this.title.equals(child)) {
                    child.dispose();
                }
                ++n2;
            }
            this.createControls(layout);
            this.container.getParent().layout(true);
            this.container.getParent().getParent().layout(true);
        }
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        switch (layout) {
            case FULL: {
                this.filInValues(0, snapshot.getCategories());
                break;
            }
            case REDUCED: {
                this.fillInReducedValues(snapshot);
                break;
            }
            case RELEVANT: {
                this.fillInOnlyRelevantValues(snapshot);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.container.layout();
    }

    private void fillInOnlyRelevantValues(ClientPerformanceSnapshot snapshot) {
        List categories = snapshot.getCategories();
        LocalDate startDate = snapshot.getStartClientSnapshot().getTime();
        String header = MessageFormat.format(Messages.PerformanceRelevantTransactionsHeader, Values.Date.format((Object)startDate));
        this.labels[0].setText(header);
        int i = 1;
        while (i < 7) {
            ClientPerformanceSnapshot.Category category = (ClientPerformanceSnapshot.Category)categories.get(i);
            this.signs[i].setText(category.getSign());
            this.labels[i].setText(category.getLabel());
            this.values[i].setText(Values.Money.format(category.getValuation(), this.getClient().getBaseCurrency()));
            ++i;
        }
        this.signs[7].setText("=");
        LocalDate endDate = snapshot.getEndClientSnapshot().getTime();
        String footer = MessageFormat.format(Messages.PerformanceRelevantTransactionsFooter, Values.Date.format((Object)endDate));
        this.labels[7].setText(footer);
        Money totalRelevantTransactions = this.sumCategoryValuations(snapshot.getValue(ClientPerformanceSnapshot.CategoryType.INITIAL_VALUE).getCurrencyCode(), categories.subList(1, 6));
        this.values[7].setText(Values.Money.format(totalRelevantTransactions, this.getClient().getBaseCurrency()));
    }

    private Money sumCategoryValuations(String currencyCode, List<ClientPerformanceSnapshot.Category> categories) {
        MutableMoney totalMoney = MutableMoney.of((String)currencyCode);
        for (ClientPerformanceSnapshot.Category category : categories) {
            switch (category.getSign()) {
                case "+": {
                    totalMoney.add(category.getValuation());
                    break;
                }
                case "-": {
                    totalMoney.subtract(category.getValuation());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return totalMoney.toMoney();
    }

    private void filInValues(int startIndex, List<ClientPerformanceSnapshot.Category> categories) {
        int ii = startIndex;
        for (ClientPerformanceSnapshot.Category category : categories) {
            this.signs[ii].setText(category.getSign());
            this.labels[ii].setText(category.getLabel());
            this.values[ii].setText(Values.Money.format(category.getValuation(), this.getClient().getBaseCurrency()));
            if (++ii >= this.labels.length) break;
        }
    }

    private void fillInReducedValues(ClientPerformanceSnapshot snapshot) {
        List categories = snapshot.getCategories();
        int count = ClientPerformanceSnapshot.CategoryType.values().length;
        int showFirstXItems = 3;
        int showLastXItems = 2;
        Money misc = this.sumCategoryValuations(snapshot.getValue(ClientPerformanceSnapshot.CategoryType.INITIAL_VALUE).getCurrencyCode(), categories.subList(showFirstXItems, count - showLastXItems));
        this.filInValues(0, categories.subList(0, showFirstXItems));
        this.signs[showFirstXItems].setText("+");
        this.labels[showFirstXItems].setText(Messages.LabelCategoryOtherMovements);
        this.values[showFirstXItems].setText(Values.Money.format(misc, this.getClient().getBaseCurrency()));
        this.filInValues(showFirstXItems + 1, categories.subList(categories.size() - showLastXItems, categories.size()));
    }

    static class LayoutConfig
    extends EnumBasedConfig<TableLayout> {
        public LayoutConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.LabelLayout, TableLayout.class, Dashboard.Config.LAYOUT, EnumBasedConfig.Policy.EXACTLY_ONE);
        }
    }

    static enum TableLayout {
        FULL(Messages.LabelLayoutFull),
        REDUCED(Messages.LabelLayoutReduced),
        RELEVANT(Messages.LabelLayoutRelevant);

        private String label;

        private TableLayout(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

