/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.text.MessageFormat;
import java.util.List;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dataseries.BasicDataSeriesConfigurator;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSerializer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class MultiDataSeriesConfig
implements WidgetConfig {
    private final BasicDataSeriesConfigurator configurator;

    public MultiDataSeriesConfig(WidgetDelegate<?> delegate) {
        this.configurator = new BasicDataSeriesConfigurator(delegate.getClient(), delegate.getDashboardData().getDataSeriesSet());
        String selected = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.DATA_SERIES.name());
        if (selected != null && !selected.isEmpty()) {
            this.configurator.setSelectedData(selected);
        }
        this.configurator.addListener(() -> {
            delegate.getWidget().getConfiguration().put(Dashboard.Config.DATA_SERIES.name(), new DataSeriesSerializer().toString(this.configurator.getSelectedDataSeries()));
            delegate.update();
            delegate.getClient().touch();
        });
    }

    public List<DataSeries> getDataSeries() {
        return this.configurator.getSelectedDataSeries();
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        manager.appendToGroup("info", (IAction)new LabelOnly(MessageFormat.format(Messages.LabelNumberDataSeries, this.configurator.getSelectedDataSeries().size())));
        MenuManager subMenu = new MenuManager(Messages.LabelDataSeries);
        this.configurator.configMenuAboutToShow((IMenuManager)subMenu);
        manager.add((IContributionItem)subMenu);
    }

    @Override
    public String getLabel() {
        return String.valueOf(Messages.LabelDataSeries) + ": " + MessageFormat.format(Messages.LabelNumberDataSeries, this.configurator.getSelectedDataSeries().size());
    }
}

