/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class ExchangeRateSeriesConfig
implements WidgetConfig {
    private WidgetDelegate<?> delegate;
    private List<ExchangeRateTimeSeries> available;
    private ExchangeRateTimeSeries series;

    public ExchangeRateSeriesConfig(WidgetDelegate<?> delegate) {
        this.delegate = delegate;
        ExchangeRateProviderFactory factory = delegate.getDashboardData().getExchangeRateProviderFactory();
        this.available = factory.getAvailableTimeSeries();
        Collections.sort(this.available, (a, b) -> {
            int c = a.getBaseCurrency().compareTo(b.getBaseCurrency());
            if (c != 0) {
                return c;
            }
            return a.getTermCurrency().compareTo(b.getTermCurrency());
        });
        String code = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.EXCHANGE_RATE_SERIES.name());
        int slash = code != null ? code.indexOf(47) : -1;
        String base = slash > 0 ? code.substring(0, slash) : null;
        String term = slash > 0 ? code.substring(slash + 1) : null;
        this.series = this.available.stream().filter(t -> t.getBaseCurrency().equals(base)).filter(t -> t.getTermCurrency().equals(term)).findAny().orElse(factory.getTimeSeries("EUR", "USD"));
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        manager.appendToGroup("info", (IAction)new LabelOnly(this.getLabel()));
        MenuManager subMenu = new MenuManager(Messages.LabelExchangeRate);
        this.available.stream().forEach(ts -> {
            SimpleAction action = new SimpleAction(ts.getLabel(), a -> {
                this.series = ts;
                String code = String.valueOf(ts.getBaseCurrency()) + '/' + ts.getTermCurrency();
                this.delegate.getWidget().getConfiguration().put(Dashboard.Config.EXCHANGE_RATE_SERIES.name(), code);
                this.delegate.update();
                this.delegate.getClient().touch();
            });
            action.setChecked(this.series.equals(ts));
            subMenu.add((IAction)action);
        });
        manager.add((IContributionItem)subMenu);
    }

    @Override
    public String getLabel() {
        Optional provider = this.series.getProvider();
        return provider.isPresent() ? String.valueOf(this.series.getLabel()) + ' ' + ((ExchangeRateProvider)provider.get()).getName() : this.series.getLabel();
    }

    public ExchangeRateTimeSeries getSeries() {
        return this.series;
    }
}

