/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class ClientFilterConfig
implements WidgetConfig {
    private WidgetDelegate<?> delegate;
    private ClientFilterMenu menu;

    public ClientFilterConfig(WidgetDelegate<?> delegate) {
        this.delegate = delegate;
        this.menu = new ClientFilterMenu(delegate.getClient(), delegate.getDashboardData().getPreferences(), f -> this.filterSelected());
        String uuid = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.CLIENT_FILTER.name());
        this.menu.getAllItems().filter(item -> item.getUUIDs().equals(uuid)).findAny().ifPresent(item -> this.menu.select((ClientFilterMenu.Item)item));
    }

    private void filterSelected() {
        this.delegate.getWidget().getConfiguration().put(Dashboard.Config.CLIENT_FILTER.name(), this.menu.getSelectedItem().getUUIDs());
        this.delegate.update();
        this.delegate.getClient().touch();
    }

    @Override
    public String getLabel() {
        return String.valueOf(Messages.LabelClientFilter) + ": " + this.menu.getSelectedItem().getLabel();
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        manager.appendToGroup("info", (IAction)new LabelOnly(this.getLabel()));
        MenuManager subMenu = new MenuManager(Messages.LabelClientFilter);
        manager.add((IContributionItem)subMenu);
        this.menu.menuAboutToShow((IMenuManager)subMenu);
    }

    public ClientFilter getSelectedFilter() {
        return this.menu.getSelectedFilter();
    }
}

