/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.ConfigurationSet;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.snapshot.Aggregation;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.PerformanceChartView;
import name.abuchen.portfolio.ui.views.StatementOfAssetsHistoryView;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSerializer;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSet;
import name.abuchen.portfolio.ui.views.dataseries.PerformanceChartSeriesBuilder;
import name.abuchen.portfolio.ui.views.dataseries.StatementOfAssetsSeriesBuilder;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.swtchart.ISeries;

public class ChartWidget
extends WidgetDelegate<Object> {
    private DataSeries.UseCase useCase;
    private DataSeriesSet dataSeriesSet;
    private Label title;
    private TimelineChart chart;

    public ChartWidget(Dashboard.Widget widget, DashboardData dashboardData, DataSeries.UseCase useCase) {
        super(widget, dashboardData);
        this.useCase = useCase;
        this.dataSeriesSet = new DataSeriesSet(dashboardData.getClient(), dashboardData.getPreferences(), useCase);
        this.addConfig(new ChartConfig(this, useCase));
        if (useCase == DataSeries.UseCase.PERFORMANCE) {
            this.addConfig(new AggregationConfig(this));
        }
        this.addConfig(new ReportingPeriodConfig(this));
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        this.title = new Label(container, 0);
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.title);
        this.chart = new TimelineChart(container);
        this.chart.getTitle().setVisible(false);
        this.chart.getTitle().setText(this.title.getText());
        this.chart.getAxisSet().getYAxis(0).getTick().setVisible(false);
        if (this.useCase != DataSeries.UseCase.STATEMENT_OF_ASSETS) {
            this.chart.getToolTip().setValueFormat(new DecimalFormat("0.##%"));
        }
        this.chart.getToolTip().reverseLabels(true);
        GC gc = new GC((Drawable)container);
        gc.setFont(resources.getKpiFont());
        Point stringExtend = gc.stringExtent("X");
        gc.dispose();
        GridDataFactory.fillDefaults().hint(-1, stringExtend.y * 6).grab(true, false).applyTo((Control)this.chart);
        this.getDashboardData().getStylingEngine().style((Object)this.chart);
        container.layout();
        return container;
    }

    @Override
    public Control getTitleControl() {
        return this.title;
    }

    @Override
    public Supplier<Object> getUpdateTask() {
        DataSeriesCache cache = this.getDashboardData().getDataSeriesCache();
        List<DataSeries> series = new DataSeriesSerializer().fromString(this.dataSeriesSet, this.get(ChartConfig.class).getData());
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
        return () -> {
            series.forEach(s -> {
                PerformanceIndex performanceIndex = cache.lookup((DataSeries)s, interval);
            });
            return null;
        };
    }

    @Override
    public void update(Object object) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        try {
            this.chart.suspendUpdate(true);
            this.chart.getTitle().setText(this.title.getText());
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            List series = Lists.reverse(new DataSeriesSerializer().fromString(this.dataSeriesSet, this.get(ChartConfig.class).getData()));
            Interval reportingPeriod = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
            switch (this.useCase) {
                case STATEMENT_OF_ASSETS: {
                    this.buildAssetSeries(series, reportingPeriod);
                    break;
                }
                case PERFORMANCE: {
                    this.buildPerformanceSeries(series, reportingPeriod);
                    break;
                }
                case RETURN_VOLATILITY: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.chart.adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        this.chart.redraw();
    }

    private void buildAssetSeries(List<DataSeries> series, Interval reportingPeriod) {
        StatementOfAssetsSeriesBuilder b1 = new StatementOfAssetsSeriesBuilder(this.chart, this.getDashboardData().getDataSeriesCache());
        series.forEach(s -> b1.build((DataSeries)s, reportingPeriod));
    }

    private void buildPerformanceSeries(List<DataSeries> series, Interval reportingPeriod) {
        PerformanceChartSeriesBuilder b2 = new PerformanceChartSeriesBuilder(this.chart, this.getDashboardData().getDataSeriesCache());
        series.forEach(s -> b2.build((DataSeries)s, reportingPeriod, this.get(AggregationConfig.class).getAggregation()));
    }

    private class AggregationConfig
    implements WidgetConfig {
        private WidgetDelegate<?> delegate;
        private Aggregation.Period aggregation;

        public AggregationConfig(WidgetDelegate<?> delegate) {
            this.delegate = delegate;
            try {
                String code = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.AGGREGATION.name());
                if (code != null) {
                    this.aggregation = Aggregation.Period.valueOf((String)code);
                }
            }
            catch (IllegalArgumentException ignore) {
                PortfolioPlugin.log(ignore);
            }
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            manager.appendToGroup("info", (IAction)new LabelOnly(this.aggregation != null ? this.aggregation.toString() : Messages.LabelAggregationDaily));
            MenuManager subMenu = new MenuManager(Messages.LabelAggregation);
            SimpleAction action = new SimpleAction(Messages.LabelAggregationDaily, a -> {
                this.aggregation = null;
                this.delegate.getWidget().getConfiguration().remove(Dashboard.Config.AGGREGATION.name());
                this.delegate.update();
                this.delegate.getClient().touch();
            });
            action.setChecked(this.aggregation == null);
            subMenu.add((IAction)action);
            Arrays.stream(Aggregation.Period.values()).forEach(a -> {
                SimpleAction menu = new SimpleAction(a.toString(), x -> {
                    this.aggregation = a;
                    this.delegate.getWidget().getConfiguration().put(Dashboard.Config.AGGREGATION.name(), a.name());
                    this.delegate.update();
                    this.delegate.getClient().touch();
                });
                menu.setChecked(this.aggregation == a);
                subMenu.add((IAction)menu);
            });
            manager.add((IContributionItem)subMenu);
        }

        public Aggregation.Period getAggregation() {
            return this.aggregation;
        }

        @Override
        public String getLabel() {
            return String.valueOf(Messages.LabelAggregation) + ": " + (this.aggregation != null ? this.aggregation.toString() : Messages.LabelAggregationDaily);
        }
    }

    private class ChartConfig
    implements WidgetConfig {
        private WidgetDelegate<?> delegate;
        private ConfigurationSet configSet;
        private ConfigurationSet.Configuration config;

        public ChartConfig(WidgetDelegate<?> delegate, DataSeries.UseCase useCase) {
            this.delegate = delegate;
            String configName = String.valueOf((useCase == DataSeries.UseCase.STATEMENT_OF_ASSETS ? StatementOfAssetsHistoryView.class : PerformanceChartView.class).getSimpleName()) + "-PICKER";
            this.configSet = delegate.getClient().getSettings().getConfigurationSet(configName);
            String uuid = (String)delegate.getWidget().getConfiguration().get(Dashboard.Config.CONFIG_UUID.name());
            this.config = this.configSet.lookup(uuid).orElseGet(() -> this.configSet.getConfigurations().findFirst().orElseGet(() -> new ConfigurationSet.Configuration(Messages.LabelNoName, null)));
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            manager.appendToGroup("info", (IAction)new LabelOnly(this.config != null ? this.config.getName() : Messages.LabelNoName));
            MenuManager subMenu = new MenuManager(Messages.ClientEditorLabelChart);
            this.configSet.getConfigurations().forEach(c -> {
                SimpleAction action = new SimpleAction(c.getName(), a -> {
                    this.config = c;
                    this.delegate.getWidget().getConfiguration().put(Dashboard.Config.CONFIG_UUID.name(), c.getUUID());
                    this.delegate.update();
                    this.delegate.getClient().touch();
                });
                action.setChecked(c.equals(this.config));
                subMenu.add((IAction)action);
            });
            manager.add((IContributionItem)subMenu);
        }

        public String getData() {
            return this.config != null ? this.config.getData() : null;
        }

        @Override
        public String getLabel() {
            return String.valueOf(Messages.ClientEditorLabelChart) + ": " + (this.config != null ? this.config.getName() : Messages.LabelNoName);
        }
    }
}

