/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.currency;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.List;
import javax.inject.Inject;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.AbstractTabbedView;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.ISeries;

public class ExchangeRatesListTab
implements AbstractTabbedView.Tab {
    @Inject
    private ExchangeRateProviderFactory providerFactory;
    @Inject
    private IPreferenceStore preferences;
    @Inject
    private IStylingEngine stylingEngine;
    private TableViewer indeces;
    private TimelineChart chart;

    @Override
    public String getTitle() {
        return Messages.LabelExchangeRates;
    }

    @Inject
    @Optional
    public void onExchangeRatesLoaded(@UIEventTopic(value="exchangeRates/loaded") Object obj) {
        this.indeces.setInput((Object)this.providerFactory.getAvailableTimeSeries());
        this.indeces.refresh();
    }

    @Override
    public Composite createTab(Composite parent) {
        Composite sash = new Composite(parent, 0);
        SashLayout sashLayout = new SashLayout(sash, 16777736);
        sash.setLayout((Layout)sashLayout);
        this.createTopTable(sash);
        this.createBottomTable(sash);
        this.chart.setLayoutData(new SashLayoutData(200));
        return sash;
    }

    protected void createTopTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.indeces = new TableViewer(container, 65536);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(ExchangeRatesListTab.class.getSimpleName()) + "@top2", this.preferences, this.indeces, layout);
        Column column = new Column(Messages.ColumnBaseCurrency, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ExchangeRateTimeSeries)element).getBaseCurrency();
            }
        });
        ColumnViewerSorter.create(ExchangeRateTimeSeries.class, "baseCurrency", "termCurrency").attachTo(column, 1024);
        support.addColumn(column);
        column = new Column(Messages.ColumnTermCurrency, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ExchangeRateTimeSeries)element).getTermCurrency();
            }
        });
        ColumnViewerSorter.create(ExchangeRateTimeSeries.class, "termCurrency", "baseCurrency").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnCurrencyProvider, 0, 150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                java.util.Optional provider = ((ExchangeRateTimeSeries)element).getProvider();
                return provider.isPresent() ? ((ExchangeRateProvider)provider.get()).getName() : "";
            }
        });
        ColumnViewerSorter.create(ExchangeRateTimeSeries.class, "provider").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnDateLatestExchangeRate, 0, 150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExchangeRateTimeSeries series = (ExchangeRateTimeSeries)element;
                List rates = series.getRates();
                return rates.isEmpty() ? null : Values.Date.format((Object)((ExchangeRate)rates.get(rates.size() - 1)).getTime());
            }
        });
        ColumnViewerSorter.create(element -> {
            ExchangeRateTimeSeries series = (ExchangeRateTimeSeries)element;
            List rates = series.getRates();
            return rates.isEmpty() ? null : ((ExchangeRate)rates.get(rates.size() - 1)).getTime();
        }).attachTo(column);
        support.addColumn(column);
        support.createColumns();
        this.indeces.getTable().setHeaderVisible(true);
        this.indeces.getTable().setLinesVisible(true);
        this.indeces.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.indeces.setInput((Object)this.providerFactory.getAvailableTimeSeries());
        this.indeces.refresh();
        this.indeces.addSelectionChangedListener(event -> this.refreshChart((ExchangeRateTimeSeries)((IStructuredSelection)event.getSelection()).getFirstElement()));
    }

    protected void createBottomTable(Composite parent) {
        this.chart = new TimelineChart(parent);
        this.stylingEngine.style((Object)this.chart);
        this.chart.getToolTip().setValueFormat(new DecimalFormat("0.0000"));
        this.refreshChart(null);
    }

    private void refreshChart(ExchangeRateTimeSeries series) {
        try {
            this.chart.suspendUpdate(true);
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            if (series == null || series.getRates().isEmpty()) {
                this.chart.getTitle().setText(Messages.LabelCurrencies);
                return;
            }
            List rates = series.getRates();
            LocalDate[] dates = new LocalDate[rates.size()];
            double[] values = new double[rates.size()];
            int ii = 0;
            for (ExchangeRate rate : rates) {
                dates[ii] = rate.getTime();
                values[ii] = rate.getValue().doubleValue();
                ++ii;
            }
            java.util.Optional provider = series.getProvider();
            String title = MessageFormat.format("{0}/{1} ({2})", series.getBaseCurrency(), series.getTermCurrency(), provider.isPresent() ? ((ExchangeRateProvider)provider.get()).getName() : "-");
            this.chart.getTitle().setText(title);
            this.chart.addDateSeries(dates, values, Colors.ICON_BLUE, title);
            this.chart.adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
            this.chart.redraw();
        }
    }
}

