/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.currency;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateProvider;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.BindingHelper;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.AbstractTabbedView;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CurrencyConverterTab
implements AbstractTabbedView.Tab {
    @Inject
    private IPreferenceStore preferences;
    private CurrencyConverterModel model;
    private BindingHelper bindings;

    @PostConstruct
    private void createModel(ExchangeRateProviderFactory factory) {
        this.model = new CurrencyConverterModel(factory);
        this.bindings = new BindingHelper(this.model);
    }

    @Override
    public String getTitle() {
        return Messages.LabelCurrencyConverter;
    }

    @Override
    public Composite createTab(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(Colors.WHITE);
        FormLayout layout = new FormLayout();
        layout.marginLeft = 20;
        layout.spacing = 20;
        container.setLayout((Layout)layout);
        Composite editArea = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(editArea);
        this.bindings.createErrorLabel(editArea);
        this.bindings.bindMandatoryAmountInput(editArea, Messages.ColumnAmount, "baseValue", 0, 10);
        this.bindings.bindCurrencyCodeCombo(editArea, Messages.ColumnBaseCurrency, "baseCurrency", false);
        this.bindings.bindMandatoryAmountInput(editArea, Messages.ColumnConvertedAmount, "termValue", 8, 10);
        this.bindings.bindCurrencyCodeCombo(editArea, Messages.ColumnTermCurrency, "termCurrency", false);
        this.bindings.bindDatePicker(editArea, Messages.ColumnDate, "date").setBackground(Colors.WHITE);
        new Label(editArea, 0);
        Button b = new Button(editArea, 0x800008);
        b.setImage(Images.INVERT_EXCHANGE_RATE.image());
        b.setToolTipText(Messages.MenuSwitchCurrencies);
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.model.flipCurrencies()));
        Composite tree = this.createTree(container);
        FormDataFactory.startingWith((Control)editArea).thenBelow((Control)tree).width(420).height(200);
        return container;
    }

    private Composite createTree(Composite container) {
        Composite area = new Composite(container, 0);
        TreeColumnLayout layout = new TreeColumnLayout();
        area.setLayout((Layout)layout);
        TreeViewer nodeViewer = new TreeViewer(area, 2048);
        ShowHideColumnHelper support = new ShowHideColumnHelper(this.getClass().getSimpleName(), this.preferences, nodeViewer, layout);
        Column column = new Column("label", Messages.ColumnExchangeRate, 0, 300);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExchangeRateTimeSeries series = (ExchangeRateTimeSeries)element;
                Optional provider = series.getProvider();
                return provider.isPresent() ? String.valueOf(series.getLabel()) + " " + ((ExchangeRateProvider)provider.get()).getName() : series.getLabel();
            }
        });
        support.addColumn(column);
        column = new Column("value", Messages.ColumnValue, 131072, 100);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExchangeRateTimeSeries series = (ExchangeRateTimeSeries)element;
                return Values.ExchangeRate.format((Object)series.lookupRate(CurrencyConverterTab.this.model.getDate()).orElse(new ExchangeRate(CurrencyConverterTab.this.model.getDate(), BigDecimal.ONE)).getValue());
            }
        });
        support.addColumn(column);
        support.createColumns();
        nodeViewer.getTree().setHeaderVisible(true);
        nodeViewer.getTree().setLinesVisible(true);
        nodeViewer.setContentProvider((IContentProvider)new ExchangeRateTimeSeriesContentProvider());
        nodeViewer.setInput((Object)this.model);
        this.model.addPropertyChangeListener(p -> nodeViewer.refresh(true));
        return area;
    }

    public static class CurrencyConverterModel
    extends BindingHelper.Model {
        private ExchangeRateProviderFactory factory;
        private CurrencyConverter currencyConverter;
        private long baseValue = Values.Amount.factorize(100.0);
        private String baseCurrency = "EUR";
        private long termValue;
        private String termCurrency = "USD";
        private LocalDate date = LocalDate.now();

        @Override
        public void applyChanges() {
            throw new UnsupportedOperationException();
        }

        public CurrencyConverterModel(ExchangeRateProviderFactory factory) {
            this.factory = Objects.requireNonNull(factory);
            this.currencyConverter = new CurrencyConverterImpl(factory, this.getTermCurrency());
            this.convert();
        }

        private void convert() {
            Money base = Money.of((String)this.getBaseCurrency(), (long)this.getBaseValue());
            Money term = this.currencyConverter.with(this.getTermCurrency()).convert(this.getDate(), base);
            this.setTermValue(term.getAmount());
        }

        public ExchangeRateTimeSeries getExchangeRateTimeSeries() {
            return this.factory.getTimeSeries(this.getBaseCurrency(), this.getTermCurrency());
        }

        public long getBaseValue() {
            return this.baseValue;
        }

        public void setBaseValue(long baseValue) {
            this.baseValue = baseValue;
            this.firePropertyChange("baseValue", this.baseValue, this.baseValue);
            this.convert();
        }

        public String getBaseCurrency() {
            return this.baseCurrency;
        }

        public void setBaseCurrency(String baseCurrency) {
            if (baseCurrency.equals(this.termCurrency)) {
                this.flipCurrencies();
            } else {
                this.baseCurrency = baseCurrency;
                this.firePropertyChange("baseCurrency", this.baseCurrency, this.baseCurrency);
                this.convert();
            }
        }

        public long getTermValue() {
            return this.termValue;
        }

        public void setTermValue(long termValue) {
            this.termValue = termValue;
            this.firePropertyChange("termValue", this.termValue, this.termValue);
        }

        public String getTermCurrency() {
            return this.termCurrency;
        }

        public void setTermCurrency(String termCurrency) {
            if (termCurrency.equals(this.baseCurrency)) {
                this.flipCurrencies();
            } else {
                this.termCurrency = termCurrency;
                this.firePropertyChange("termCurrency", this.termCurrency, this.termCurrency);
                this.convert();
            }
        }

        public LocalDate getDate() {
            return this.date;
        }

        public void setDate(LocalDate date) {
            this.date = date;
            this.firePropertyChange("date", this.date, this.date);
            this.convert();
        }

        public void flipCurrencies() {
            String oldTermCurrency;
            String oldBaseCurrency = this.baseCurrency;
            this.baseCurrency = oldTermCurrency = this.termCurrency;
            this.termCurrency = oldBaseCurrency;
            this.firePropertyChange("baseCurrency", oldBaseCurrency, this.baseCurrency);
            this.firePropertyChange("termCurrency", oldTermCurrency, this.termCurrency);
            this.convert();
        }
    }

    private static class ExchangeRateTimeSeriesContentProvider
    implements ITreeContentProvider {
        private ExchangeRateTimeSeriesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{((CurrencyConverterModel)inputElement).getExchangeRateTimeSeries()};
        }

        public Object[] getChildren(Object parentElement) {
            return ((ExchangeRateTimeSeries)parentElement).getComposition().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !((ExchangeRateTimeSeries)element).getComposition().isEmpty();
        }
    }
}

