/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class NameColumn
extends Column {
    public NameColumn(Client client) {
        this(client, "name");
    }

    public NameColumn(Client client, String id) {
        this(id, Messages.ColumnName, 16384, 300, client);
    }

    public NameColumn(String id, String label, int style, int defaultWidth, Client client) {
        super(id, label, style, defaultWidth);
        this.setLabelProvider((CellLabelProvider)new NameColumnLabelProvider(client));
        this.setSorter(ColumnViewerSorter.create(Named.class, "name"));
        new StringEditingSupport(Named.class, "name").setMandatory(true).attachTo(this);
    }

    public static class NameColumnLabelProvider
    extends ColumnLabelProvider {
        private Client client;

        public NameColumnLabelProvider(Client client) {
            this.client = client;
        }

        public String getText(Object e) {
            Named n = (Named)Adaptor.adapt(Named.class, (Object)e);
            return n != null ? n.getName() : null;
        }

        public Image getImage(Object e) {
            Named n = (Named)Adaptor.adapt(Named.class, (Object)e);
            return LogoManager.instance().getDefaultColumnImage(n, this.client.getSettings());
        }

        public String getToolTipText(Object e) {
            Named element = (Named)Adaptor.adapt(Named.class, (Object)e);
            if (element == null) {
                return null;
            }
            if (element instanceof Security) {
                return TextUtil.tooltip((String)((Security)element).toInfoString());
            }
            return TextUtil.tooltip((String)element.getName());
        }
    }
}

