/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.columns;

import java.util.function.Function;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.Column;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;

public class CalculatedQuoteColumn
extends Column {
    public CalculatedQuoteColumn(String id, Client client, Function<Object, Quote> quoteProvider) {
        this(id, client, quoteProvider, null);
    }

    public CalculatedQuoteColumn(String id, final Client client, final Function<Object, Quote> quoteProvider, final Function<Object, Color> foregroundColorProvider) {
        super(id, Messages.ColumnPerShare, 131072, 80);
        this.setDescription(Messages.ColumnPerShare_Description);
        this.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Quote quote = (Quote)quoteProvider.apply(e);
                return quote != null ? Values.CalculatedQuote.format(quote, client.getBaseCurrency()) : null;
            }

            public String getToolTipText(Object e) {
                Quote quote = (Quote)quoteProvider.apply(e);
                return quote != null ? Values.Quote.format(quote, client.getBaseCurrency()) : null;
            }

            public Color getForeground(Object element) {
                return foregroundColorProvider != null ? (Color)foregroundColorProvider.apply(element) : null;
            }
        });
    }
}

