/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.actions;

import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import org.eclipse.jface.action.Action;

public class RevertBuySellAction
extends Action {
    private final Client client;
    private final TransactionPair<?> transaction;

    public RevertBuySellAction(Client client, TransactionPair<?> transaction) {
        this.client = client;
        this.transaction = transaction;
        if (transaction.getTransaction() instanceof PortfolioTransaction) {
            PortfolioTransaction.Type type = ((PortfolioTransaction)transaction.getTransaction()).getType();
            if (type != PortfolioTransaction.Type.BUY && type != PortfolioTransaction.Type.SELL) {
                throw new IllegalArgumentException();
            }
        } else if (transaction.getTransaction() instanceof AccountTransaction) {
            AccountTransaction.Type type = ((AccountTransaction)transaction.getTransaction()).getType();
            if (type != AccountTransaction.Type.BUY && type != AccountTransaction.Type.SELL) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void run() {
        BuySellEntry buysell = (BuySellEntry)this.transaction.getTransaction().getCrossEntry();
        PortfolioTransaction tx = buysell.getPortfolioTransaction();
        Money grossAmount = tx.getUnit(Transaction.Unit.Type.GROSS_VALUE).map(Transaction.Unit::getAmount).orElse(tx.getGrossValue());
        Money feesAndTaxes = (Money)tx.getUnits().filter(u -> u.getType() == Transaction.Unit.Type.FEE || u.getType() == Transaction.Unit.Type.TAX).map(Transaction.Unit::getAmount).collect(MoneyCollectors.sum((String)tx.getCurrencyCode()));
        if (tx.getType() == PortfolioTransaction.Type.BUY) {
            buysell.getAccountTransaction().setType(AccountTransaction.Type.SELL);
            tx.setType(PortfolioTransaction.Type.SELL);
            buysell.setMonetaryAmount(grossAmount.subtract(feesAndTaxes));
        } else if (tx.getType() == PortfolioTransaction.Type.SELL) {
            buysell.getAccountTransaction().setType(AccountTransaction.Type.BUY);
            tx.setType(PortfolioTransaction.Type.BUY);
            buysell.setMonetaryAmount(grossAmount.add(feesAndTaxes));
        } else {
            throw new IllegalArgumentException();
        }
        this.client.markDirty();
    }
}

