/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.DateSelectionDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.ClientFilterDropDown;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.views.StatementOfAssetsViewer;
import name.abuchen.portfolio.util.Pair;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatementOfAssetsView
extends AbstractFinanceView {
    private StatementOfAssetsViewer assetViewer;
    private PropertyChangeListener currencyChangeListener;
    private ClientFilterDropDown clientFilter;
    private Optional<LocalDate> snapshotDate = Optional.empty();
    @Inject
    private ExchangeRateProviderFactory factory;

    @Override
    protected String getDefaultTitle() {
        return this.assetViewer == null ? Messages.LabelStatementOfAssets : String.valueOf(Messages.LabelStatementOfAssets) + " (" + this.assetViewer.getColumnHelper().getConfigurationName() + ")";
    }

    @Override
    public void notifyModelUpdated() {
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
        this.assetViewer.setInput(this.clientFilter.getSelectedFilter(), this.snapshotDate.orElse(LocalDate.now()), (CurrencyConverter)converter);
        this.updateTitle(this.getDefaultTitle());
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        DropDown dropDown = new DropDown(this.getClient().getBaseCurrency());
        Function<CurrencyUnit, Action> asAction = unit -> {
            SimpleAction action = new SimpleAction(unit.getLabel(), a -> {
                dropDown.setLabel(unit.getCurrencyCode());
                this.getClient().setBaseCurrency(unit.getCurrencyCode());
            });
            action.setChecked(this.getClient().getBaseCurrency().equals(unit.getCurrencyCode()));
            return action;
        };
        dropDown.setMenuListener(manager -> {
            this.getClient().getUsedCurrencies().forEach(unit -> manager.add((IAction)asAction.apply((CurrencyUnit)unit)));
            manager.add((IContributionItem)new Separator());
            List available = CurrencyUnit.getAvailableCurrencyUnitsGrouped();
            for (Pair pair : available) {
                MenuManager submenu = new MenuManager((String)pair.getLeft());
                manager.add((IContributionItem)submenu);
                ((List)pair.getRight()).forEach(unit -> submenu.add((IAction)asAction.apply((CurrencyUnit)unit)));
            }
        });
        toolBar.add((IContributionItem)dropDown);
        this.currencyChangeListener = e -> dropDown.setLabel(e.getNewValue().toString());
        this.getClient().addPropertyChangeListener("baseCurrency", this.currencyChangeListener);
        this.addCalendarButton(toolBar);
        this.clientFilter = new ClientFilterDropDown(this.getClient(), this.getPreferenceStore(), StatementOfAssetsView.class.getSimpleName(), filter -> this.notifyModelUpdated());
        toolBar.add((IContributionItem)this.clientFilter);
        SimpleAction export = new SimpleAction(null, action -> new TableViewerCSVExporter(this.assetViewer.getTableViewer()).export(String.valueOf(Messages.LabelStatementOfAssets) + ".csv"));
        export.setImageDescriptor(Images.EXPORT.descriptor());
        export.setToolTipText(Messages.MenuExportData);
        toolBar.add((IAction)export);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.assetViewer.menuAboutToShow(manager)));
    }

    private void addCalendarButton(ToolBarManager toolBar) {
        DropDown dropDown = new DropDown(Messages.LabelPortfolioTimeMachine, Images.CALENDAR_OFF, 0);
        dropDown.setMenuListener(manager -> {
            manager.add((IAction)new LabelOnly(Values.Date.format((Object)this.snapshotDate.orElse(LocalDate.now()))));
            manager.add((IContributionItem)new Separator());
            SimpleAction action = new SimpleAction(Messages.LabelToday, a -> {
                this.snapshotDate = Optional.empty();
                this.notifyModelUpdated();
                dropDown.setImage(Images.CALENDAR_OFF);
            });
            action.setEnabled(this.snapshotDate.isPresent());
            manager.add((IAction)action);
            manager.add((IAction)new SimpleAction(Messages.MenuPickOtherDate, a -> {
                DateSelectionDialog dialog = new DateSelectionDialog(this.getActiveShell());
                dialog.setSelection(this.snapshotDate.orElse(LocalDate.now()));
                if (dialog.open() != 0) {
                    return;
                }
                if (this.snapshotDate.isPresent() && this.snapshotDate.get().equals(dialog.getSelection())) {
                    return;
                }
                this.snapshotDate = LocalDate.now().equals(dialog.getSelection()) ? Optional.empty() : Optional.of(dialog.getSelection());
                this.notifyModelUpdated();
                dropDown.setImage(!this.snapshotDate.isPresent() ? Images.CALENDAR_OFF : Images.CALENDAR_ON);
            }));
        });
        toolBar.add((IContributionItem)dropDown);
    }

    @Override
    protected Control createBody(Composite parent) {
        this.assetViewer = this.make(StatementOfAssetsViewer.class, new Object[0]);
        Control control = this.assetViewer.createControl(parent);
        this.assetViewer.setToolBarManager(this.getViewToolBarManager());
        this.updateTitle(this.getDefaultTitle());
        this.assetViewer.getColumnHelper().addListener(() -> this.updateTitle(this.getDefaultTitle()));
        this.hookContextMenu(this.assetViewer.getTableViewer().getControl(), manager -> this.assetViewer.hookMenuListener(manager, this));
        this.notifyModelUpdated();
        return control;
    }

    @Override
    public void dispose() {
        if (this.currencyChangeListener != null) {
            this.getClient().removePropertyChangeListener("baseCurrency", this.currencyChangeListener);
        }
    }
}

