/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.QuoteQualityMetrics;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SecurityQuoteQualityMetricsViewer {
    @Inject
    private IPreferenceStore preferences;
    private Label completeness;
    private Label checkInterval;
    private TableViewer missing;

    public Control createViewControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(Colors.WHITE);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        Label lCompleteness = new Label(container, 0);
        lCompleteness.setText(Messages.ColumnMetricCompleteness);
        lCompleteness.setToolTipText(Messages.ColumnMetricCompleteness_Description);
        this.completeness = new Label(container, 0);
        this.completeness.setToolTipText(Messages.ColumnMetricCompleteness_Description);
        this.checkInterval = new Label(container, 0);
        Composite table = this.createTable(container);
        FormDataFactory.startingWith((Control)this.completeness, lCompleteness).right(new FormAttachment(100)).thenBelow((Control)this.checkInterval).left(new FormAttachment(0)).thenBelow((Control)table).bottom(new FormAttachment(100));
        return container;
    }

    protected Composite createTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.missing = new TableViewer(container, 65536);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(SecurityQuoteQualityMetricsViewer.class.getSimpleName()) + "@missing", this.preferences, this.missing, layout);
        Column column = new Column(Messages.ColumnDate, 0, 300);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Interval interval = (Interval)element;
                if (interval.getStart().equals(interval.getEnd())) {
                    return Values.Date.format((Object)interval.getStart());
                }
                return MessageFormat.format((String)Messages.LabelDateXToY, (Object[])new Object[]{Values.Date.format((Object)interval.getStart()), Values.Date.format((Object)interval.getEnd())});
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((Interval)e).getStart()), 128);
        support.addColumn(column);
        support.createColumns();
        this.missing.getTable().setHeaderVisible(true);
        this.missing.getTable().setLinesVisible(true);
        this.missing.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return container;
    }

    public void setInput(Security security) {
        if (this.completeness == null || this.completeness.isDisposed()) {
            return;
        }
        if (security == null) {
            this.completeness.setText("");
            this.checkInterval.setText("");
            this.missing.setInput(new ArrayList());
        } else {
            QuoteQualityMetrics metrics = new QuoteQualityMetrics(security);
            this.completeness.setText(Values.Percent2.format((Object)metrics.getCompleteness()));
            this.checkInterval.setText(metrics.getCheckInterval().map(i -> MessageFormat.format((String)Messages.LabelMetricCheckInterval, (Object[])new Object[]{Values.Date.format((Object)i.getStart()), Values.Date.format((Object)i.getEnd())})).orElse(""));
            this.missing.setInput((Object)metrics.getMissingIntervals());
        }
    }
}

