/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.Watchlist;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.QuoteFeed;
import name.abuchen.portfolio.online.SecuritySearchProvider;
import name.abuchen.portfolio.online.impl.PortfolioReportNet;
import name.abuchen.portfolio.snapshot.QuoteQualityMetrics;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.InvestmentPlanDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.dnd.ImportFromFileDropAdapter;
import name.abuchen.portfolio.ui.dnd.ImportFromURLDropAdapter;
import name.abuchen.portfolio.ui.dnd.SecurityDragListener;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.jobs.UpdateQuotesJob;
import name.abuchen.portfolio.ui.util.BookmarkMenu;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.ConfirmActionWithSelection;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.viewers.BooleanEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.NumberColorLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.OptionLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ReportingPeriodColumnOptions;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.StringEditingSupport;
import name.abuchen.portfolio.ui.views.QuotesContextMenu;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.views.columns.SymbolColumn;
import name.abuchen.portfolio.ui.views.columns.TaxonomyColumn;
import name.abuchen.portfolio.ui.views.columns.WknColumn;
import name.abuchen.portfolio.ui.wizards.events.CustomEventWizard;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityDialog;
import name.abuchen.portfolio.ui.wizards.splits.StockSplitWizard;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.Pair;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public final class SecuritiesTable
implements ColumnEditingSupport.ModificationListener {
    private AbstractFinanceView view;
    private Watchlist watchlist;
    private TableViewer securities;
    private Map<Security, QuoteQualityMetrics> metricsCache = new HashMap<Security, QuoteQualityMetrics>(){
        private static final long serialVersionUID = 1L;

        @Override
        public QuoteQualityMetrics get(Object key) {
            return super.computeIfAbsent((Security)key, QuoteQualityMetrics::new);
        }
    };
    private ShowHideColumnHelper support;

    public SecuritiesTable(Composite parent, AbstractFinanceView view) {
        this.view = view;
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.securities = new TableViewer(container, 65538);
        ImportFromURLDropAdapter.attach(this.securities.getControl(), view.getPart());
        ImportFromFileDropAdapter.attach(this.securities.getControl(), view.getPart());
        ColumnEditingSupport.prepare((ColumnViewer)this.securities);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.securities, (int)2);
        this.support = new ShowHideColumnHelper(SecuritiesTable.class.getName(), this.getClient(), view.getPreferenceStore(), this.securities, layout);
        this.addMasterDataColumns();
        this.addColumnLatestPrice();
        this.addDeltaColumn();
        this.addDeltaAmountColumn();
        this.addColumnDateOfLatestPrice();
        this.addColumnDateOfLatestHistoricalPrice();
        this.addQuoteDeltaColumn();
        for (Taxonomy taxonomy : this.getClient().getTaxonomies()) {
            TaxonomyColumn column = new TaxonomyColumn(taxonomy);
            column.setVisible(false);
            this.support.addColumn(column);
        }
        this.addAttributeColumns();
        this.addQuoteFeedColumns();
        this.addDataQualityColumns();
        this.support.createColumns();
        this.securities.getTable().setHeaderVisible(true);
        this.securities.getTable().setLinesVisible(true);
        this.securities.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.securities.addDragSupport(2, new Transfer[]{SecurityTransfer.getTransfer()}, (DragSourceListener)new SecurityDragListener((StructuredViewer)this.securities));
        this.hookKeyListener();
        this.securities.refresh();
        this.hookContextMenu();
    }

    private void addMasterDataColumns() {
        Column column = new Column("0", Messages.ColumnName, 16384, 400);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Security)e).getName();
            }

            public Image getImage(Object e) {
                return LogoManager.instance().getDefaultColumnImage(e, SecuritiesTable.this.getClient().getSettings());
            }
        });
        ColumnViewerSorter.create(Security.class, "name").attachTo(column, 1024);
        new StringEditingSupport(Security.class, "name").setMandatory(true).addListener(this).attachTo(column);
        this.support.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new IsinColumn("1");
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new SymbolColumn("2");
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new WknColumn("7");
        column.getEditingSupport().addListener(this);
        this.support.addColumn(column);
        column = new Column("currency", Messages.ColumnCurrency, 16384, 60);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getCurrencyCode();
            }
        });
        column.setSorter(ColumnViewerSorter.create(element -> ((Security)element).getCurrencyCode()));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("targetCurrency", Messages.ColumnTargetCurrency, 16384, 60);
        column.setDescription(Messages.ColumnTargetCurrencyToolTip);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Security)element).getTargetCurrencyCode();
            }
        });
        column.setSorter(ColumnViewerSorter.create(element -> ((Security)element).getTargetCurrencyCode()));
        column.setVisible(false);
        this.support.addColumn(column);
        column = new Column("8", Messages.ColumnRetired, 16384, 40);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return "";
            }

            public Image getImage(Object e) {
                return ((Security)e).isRetired() ? Images.CHECK.image() : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(Security.class, "retired"));
        new BooleanEditingSupport(Security.class, "retired").addListener(this).attachTo(column);
        column.setVisible(false);
        this.support.addColumn(column);
    }

    private void addColumnLatestPrice() {
        Column column = new Column("4", Messages.ColumnLatest, 131072, 60);
        column.setMenuLabel(Messages.ColumnLatest_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Security security = (Security)e;
                SecurityPrice latest = security.getSecurityPrice(LocalDate.now());
                if (latest == null) {
                    return null;
                }
                if (security.getCurrencyCode() == null) {
                    return Values.Quote.format(Long.valueOf(latest.getValue()));
                }
                return Values.Quote.format(security.getCurrencyCode(), latest.getValue(), SecuritiesTable.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            SecurityPrice p1 = ((Security)o1).getSecurityPrice(LocalDate.now());
            SecurityPrice p2 = ((Security)o2).getSecurityPrice(LocalDate.now());
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            return Long.compare(p1.getValue(), p2.getValue());
        }));
        this.support.addColumn(column);
    }

    private void addDeltaColumn() {
        Column column = new Column("5", Messages.ColumnChangeOnPrevious, 131072, 80);
        column.setMenuLabel(Messages.ColumnChangeOnPrevious_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, element -> {
            Optional previous = ((Security)element).getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                double latestQuote = ((SecurityPrice)((Pair)previous.get()).getLeft()).getValue();
                double previousQuote = ((SecurityPrice)((Pair)previous.get()).getRight()).getValue();
                return (latestQuote - previousQuote) / previousQuote;
            }
            return null;
        }, element -> {
            Optional previous = ((Security)element).getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                return String.valueOf(Messages.ColumnLatestPrice) + ": " + MessageFormat.format(Messages.TooltipQuoteAtDate, Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getLeft()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getLeft()).getDate())) + "\n" + Messages.ColumnPreviousPrice + ": " + MessageFormat.format(Messages.TooltipQuoteAtDate, Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getRight()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getRight()).getDate()));
            }
            return null;
        }));
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            Optional previous1 = ((Security)o1).getLatestTwoSecurityPrices();
            Optional previous2 = ((Security)o2).getLatestTwoSecurityPrices();
            if (!previous1.isPresent() && !previous2.isPresent()) {
                return 0;
            }
            if (!previous1.isPresent() && previous2.isPresent()) {
                return -1;
            }
            if (previous1.isPresent() && !previous2.isPresent()) {
                return 1;
            }
            double latestQuote1 = ((SecurityPrice)((Pair)previous1.get()).getLeft()).getValue();
            double previousQuote1 = ((SecurityPrice)((Pair)previous1.get()).getRight()).getValue();
            double v1 = (latestQuote1 - previousQuote1) / previousQuote1;
            double latestQuote2 = ((SecurityPrice)((Pair)previous2.get()).getLeft()).getValue();
            double previousQuote2 = ((SecurityPrice)((Pair)previous2.get()).getRight()).getValue();
            double v2 = (latestQuote2 - previousQuote2) / previousQuote2;
            return Double.compare(v1, v2);
        }));
        this.support.addColumn(column);
    }

    private void addDeltaAmountColumn() {
        Column column = new Column("changeonpreviousamount", Messages.ColumnChangeOnPreviousAmount, 131072, 80);
        column.setMenuLabel(Messages.ColumnChangeOnPrevious_MenuLabelAmount);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Long>((Values<Long>)Values.CalculatedQuote, element -> {
            Optional previous = ((Security)element).getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                double latestQuote = ((SecurityPrice)((Pair)previous.get()).getLeft()).getValue();
                double previousQuote = ((SecurityPrice)((Pair)previous.get()).getRight()).getValue();
                return (long)(latestQuote - previousQuote);
            }
            return null;
        }, element -> {
            Optional previous = ((Security)element).getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                return String.valueOf(Messages.ColumnLatestPrice) + ": " + MessageFormat.format(Messages.TooltipQuoteAtDate, Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getLeft()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getLeft()).getDate())) + "\n" + Messages.ColumnPreviousPrice + ": " + MessageFormat.format(Messages.TooltipQuoteAtDate, Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getRight()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getRight()).getDate()));
            }
            return null;
        }));
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            Optional previous1 = ((Security)o1).getLatestTwoSecurityPrices();
            Optional previous2 = ((Security)o2).getLatestTwoSecurityPrices();
            if (!previous1.isPresent() && !previous2.isPresent()) {
                return 0;
            }
            if (!previous1.isPresent() && previous2.isPresent()) {
                return -1;
            }
            if (previous1.isPresent() && !previous2.isPresent()) {
                return 1;
            }
            double latestQuote1 = ((SecurityPrice)((Pair)previous1.get()).getLeft()).getValue();
            double previousQuote1 = ((SecurityPrice)((Pair)previous1.get()).getRight()).getValue();
            double v1 = latestQuote1 - previousQuote1;
            double latestQuote2 = ((SecurityPrice)((Pair)previous2.get()).getLeft()).getValue();
            double previousQuote2 = ((SecurityPrice)((Pair)previous2.get()).getRight()).getValue();
            double v2 = latestQuote2 - previousQuote2;
            return Double.compare(v1, v2);
        }));
        this.support.addColumn(column);
    }

    private void addColumnDateOfLatestPrice() {
        Column column = new Column("9", Messages.ColumnLatestDate, 16384, 80);
        column.setMenuLabel(Messages.ColumnLatestDate_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SecurityPrice latest = ((Security)element).getSecurityPrice(LocalDate.now());
                return latest != null ? Values.Date.format((Object)latest.getDate()) : null;
            }

            public Color getBackground(Object element) {
                String feed;
                Security security = (Security)element;
                SecurityPrice latest = security.getSecurityPrice(LocalDate.now());
                if (latest == null) {
                    return null;
                }
                String string = feed = security.getLatestFeed() != null ? security.getLatestFeed() : security.getFeed();
                if ("MANUAL".equals(feed)) {
                    return null;
                }
                LocalDate sevenDaysAgo = LocalDate.now().minusDays(7L);
                return latest.getDate().isBefore(sevenDaysAgo) ? Colors.theme().warningBackground() : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            SecurityPrice p1 = ((Security)o1).getSecurityPrice(LocalDate.now());
            SecurityPrice p2 = ((Security)o2).getSecurityPrice(LocalDate.now());
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.getDate().compareTo(p2.getDate());
        }));
        this.support.addColumn(column);
    }

    private void addColumnDateOfLatestHistoricalPrice() {
        Column column = new Column("10", Messages.ColumnLatestHistoricalDate, 16384, 80);
        column.setMenuLabel(Messages.ColumnLatestHistoricalDate_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List prices = ((Security)element).getPrices();
                if (prices.isEmpty()) {
                    return null;
                }
                SecurityPrice latest = (SecurityPrice)prices.get(prices.size() - 1);
                return latest != null ? Values.Date.format((Object)latest.getDate()) : null;
            }

            public Color getBackground(Object element) {
                Security security = (Security)element;
                List prices = security.getPrices();
                if (prices.isEmpty()) {
                    return null;
                }
                if ("MANUAL".equals(security.getFeed())) {
                    return null;
                }
                SecurityPrice latest = (SecurityPrice)prices.get(prices.size() - 1);
                if (!((Security)element).isRetired() && latest.getDate().isBefore(LocalDate.now().minusDays(7L))) {
                    return Colors.theme().warningBackground();
                }
                return null;
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            SecurityPrice p2;
            List prices1 = ((Security)o1).getPrices();
            SecurityPrice p1 = prices1.isEmpty() ? null : (SecurityPrice)prices1.get(prices1.size() - 1);
            List prices2 = ((Security)o2).getPrices();
            SecurityPrice securityPrice = p2 = prices2.isEmpty() ? null : (SecurityPrice)prices2.get(prices2.size() - 1);
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.getDate().compareTo(p2.getDate());
        }));
        this.support.addColumn(column);
    }

    private void addQuoteDeltaColumn() {
        ArrayList<ReportingPeriod> options = new ArrayList<ReportingPeriod>(this.view.getPart().getReportingPeriods());
        BiFunction<Object, ReportingPeriod, Double> valueProvider = (element, option) -> {
            Interval interval = option.toInterval(LocalDate.now());
            Security security = (Security)element;
            SecurityPrice latest = security.getSecurityPrice(interval.getEnd());
            SecurityPrice previous = security.getSecurityPrice(interval.getStart());
            if (latest == null || previous == null) {
                return null;
            }
            if (previous.getValue() == 0L) {
                return null;
            }
            if (previous.getDate().isAfter(interval.getStart())) {
                return null;
            }
            return (double)(latest.getValue() - previous.getValue()) / (double)previous.getValue();
        };
        Column column = new Column("delta-w-period", Messages.ColumnQuoteChange, 131072, 80);
        column.setOptions(new ReportingPeriodColumnOptions(Messages.ColumnQuoteChange_Option, options));
        column.setDescription(Messages.ColumnQuoteChange_Description);
        column.setLabelProvider(new QuoteReportingPeriodLabelProvider(valueProvider));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            ReportingPeriod option = (ReportingPeriod)ColumnViewerSorter.SortingContext.getColumnOption();
            Double v1 = (Double)valueProvider.apply(o1, option);
            Double v2 = (Double)valueProvider.apply(o2, option);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return Double.compare(v1, v2);
        }));
        this.support.addColumn(column);
    }

    private void addAttributeColumns() {
        AttributeColumn.createFor(this.getClient(), Security.class).forEach(column -> {
            column.getEditingSupport().addListener(this);
            this.support.addColumn((Column)column);
        });
    }

    private void addQuoteFeedColumns() {
        final Function<Object, String> quoteFeed = e -> {
            String feedId = ((Security)e).getFeed();
            if (feedId == null || feedId.isEmpty()) {
                return null;
            }
            QuoteFeed feed = Factory.getQuoteFeedProvider((String)feedId);
            return feed != null ? feed.getName() : null;
        };
        Column column = new Column("qf-historic", Messages.ColumnQuoteFeedHistoric, 16384, 200);
        column.setGroupLabel(Messages.GroupLabelQuoteFeed);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return (String)quoteFeed.apply(e);
            }
        });
        column.setSorter(ColumnViewerSorter.create(quoteFeed::apply));
        this.support.addColumn(column);
        final Function<Object, String> latestQuoteFeed = e -> {
            Security security = (Security)e;
            String feedId = security.getLatestFeed();
            if (feedId == null || feedId.isEmpty()) {
                return security.getFeed() != null ? Messages.EditWizardOptionSameAsHistoricalQuoteFeed : null;
            }
            QuoteFeed feed = Factory.getQuoteFeedProvider((String)feedId);
            return feed != null ? feed.getName() : null;
        };
        column = new Column("qf-latest", Messages.ColumnQuoteFeedLatest, 16384, 200);
        column.setGroupLabel(Messages.GroupLabelQuoteFeed);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return (String)latestQuoteFeed.apply(e);
            }
        });
        column.setSorter(ColumnViewerSorter.create(latestQuoteFeed::apply));
        this.support.addColumn(column);
        column = new Column("url-history", Messages.ColumnFeedURLHistoric, 16384, 200);
        column.setGroupLabel(Messages.GroupLabelQuoteFeed);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Security security = (Security)e;
                return security.getFeedURL();
            }
        });
        column.setSorter(ColumnViewerSorter.create(Security.class, "feedURL"));
        this.support.addColumn(column);
        column = new Column("url-latest", Messages.ColumnFeedURLLatest, 16384, 200);
        column.setGroupLabel(Messages.GroupLabelQuoteFeed);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Security security = (Security)e;
                return security.getLatestFeedURL();
            }
        });
        column.setSorter(ColumnViewerSorter.create(Security.class, "latestFeedURL"));
        this.support.addColumn(column);
    }

    private void addDataQualityColumns() {
        Column column = new Column("q-date-first-historic", Messages.ColumnDateFirstHistoricalQuote, 16384, 80);
        column.setMenuLabel(Messages.ColumnDateFirstHistoricalQuote_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                List prices = ((Security)element).getPrices();
                return prices.isEmpty() ? null : Values.Date.format((Object)((SecurityPrice)prices.get(0)).getDate());
            }
        });
        column.setSorter(ColumnViewerSorter.create(element -> {
            List prices = ((Security)element).getPrices();
            return prices.isEmpty() ? null : ((SecurityPrice)prices.get(0)).getDate();
        }));
        this.support.addColumn(column);
        column = new Column("qqm-completeness", Messages.ColumnMetricCompleteness, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setDescription(Messages.ColumnMetricCompleteness_Description);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.Percent2.format((Object)SecuritiesTable.this.metricsCache.get((Security)e).getCompleteness());
            }
        });
        column.setSorter(ColumnViewerSorter.create(o -> Double.valueOf(this.metricsCache.get((Security)o).getCompleteness())));
        this.support.addColumn(column);
        column = new Column("qqm-expected", Messages.ColumnMetricExpectedNumberOfQuotes, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Integer.toString(SecuritiesTable.this.metricsCache.get((Security)e).getExpectedNumberOfQuotes());
            }
        });
        column.setSorter(ColumnViewerSorter.create(o -> Integer.valueOf(this.metricsCache.get((Security)o).getExpectedNumberOfQuotes())));
        this.support.addColumn(column);
        column = new Column("qqm-actual", Messages.ColumnMetricActualNumberOfQuotes, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Integer.toString(SecuritiesTable.this.metricsCache.get((Security)e).getActualNumberOfQuotes());
            }
        });
        column.setSorter(ColumnViewerSorter.create(o -> Integer.valueOf(this.metricsCache.get((Security)o).getActualNumberOfQuotes())));
        this.support.addColumn(column);
        column = new Column("qqm-missing", Messages.ColumnMetricNumberOfMissingQuotes, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDataQuality);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                QuoteQualityMetrics metrics = SecuritiesTable.this.metricsCache.get((Security)e);
                return Integer.toString(metrics.getExpectedNumberOfQuotes() - metrics.getActualNumberOfQuotes());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            QuoteQualityMetrics metrics = this.metricsCache.get((Security)e);
            return Integer.valueOf(metrics.getExpectedNumberOfQuotes() - metrics.getActualNumberOfQuotes());
        }));
        this.support.addColumn(column);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.securities.addSelectionChangedListener(listener);
    }

    public void addFilter(ViewerFilter filter) {
        this.securities.addFilter(filter);
    }

    public void setInput(List<Security> securities) {
        this.securities.setInput(securities);
        this.watchlist = null;
    }

    public void setInput(Watchlist watchlist) {
        this.securities.setInput((Object)watchlist.getSecurities());
        this.watchlist = watchlist;
    }

    public void refresh(Security security) {
        this.metricsCache.remove(security);
        this.securities.refresh((Object)security, true);
    }

    public void refresh(boolean updateLabels) {
        try {
            this.securities.getControl().setRedraw(false);
            if (updateLabels) {
                this.metricsCache.clear();
            }
            this.securities.refresh(updateLabels);
            this.securities.setSelection(this.securities.getSelection());
        }
        finally {
            this.securities.getControl().setRedraw(true);
        }
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.markDirty();
    }

    public void updateQuotes(Security security) {
        new UpdateQuotesJob(this.getClient(), security).schedule();
    }

    public TableViewer getTableViewer() {
        return this.securities;
    }

    public ShowHideColumnHelper getColumnHelper() {
        return this.support;
    }

    private Client getClient() {
        return this.view.getClient();
    }

    private Shell getShell() {
        return this.securities.getTable().getShell();
    }

    private void markDirty() {
        this.view.markDirty();
    }

    private void hookKeyListener() {
        this.securities.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 101 && e.stateMask == SWT.MOD1) {
                    new EditSecurityAction().run();
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu contextMenu = menuMgr.createContextMenu((Control)this.securities.getTable());
        this.securities.getTable().setMenu(contextMenu);
        this.securities.getTable().addDisposeListener(e -> {
            if (contextMenu != null) {
                contextMenu.dispose();
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        final IStructuredSelection selection = (IStructuredSelection)this.securities.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1) {
            Security security = (Security)selection.getFirstElement();
            if (security.getCurrencyCode() != null) {
                this.fillTransactionContextMenu(manager, security);
            }
            manager.add((IAction)new EditSecurityAction());
            manager.add((IContributionItem)new Separator());
            new QuotesContextMenu(this.view).menuAboutToShow(manager, security);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new BookmarkMenu(this.view.getPart(), security));
            if (security.getOnlineId() == null) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new LinkToPortfolioReport(security));
            }
        }
        manager.add((IContributionItem)new Separator());
        if (this.watchlist == null) {
            manager.add((IAction)new ConfirmActionWithSelection(Messages.SecurityMenuDeleteSecurity, MessageFormat.format(Messages.SecurityMenuDeleteSingleSecurityConfirm, selection.getFirstElement()), Messages.SecurityMenuDeleteMultipleSecurityConfirm, selection, (s, a) -> this.deleteSecurity(selection)));
        } else {
            manager.add((IAction)new Action(MessageFormat.format(Messages.SecurityMenuRemoveFromWatchlist, this.watchlist.getName())){

                public void run() {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object security = objectArray[n2];
                        SecuritiesTable.this.watchlist.getSecurities().remove(security);
                        ++n2;
                    }
                    SecuritiesTable.this.markDirty();
                    SecuritiesTable.this.securities.setInput((Object)SecuritiesTable.this.watchlist.getSecurities());
                }
            });
        }
    }

    private void fillTransactionContextMenu(IMenuManager manager, Security security) {
        new OpenDialogAction(this.view, String.valueOf(Messages.SecurityMenuBuy) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.BUY).with(security).addTo(manager);
        new OpenDialogAction(this.view, String.valueOf(Messages.SecurityMenuSell) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.SELL).with(security).addTo(manager);
        new OpenDialogAction(this.view, String.valueOf(Messages.SecurityMenuDividends) + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.DIVIDENDS).with(security).addTo(manager);
        new OpenDialogAction(this.view, AccountTransaction.Type.TAX_REFUND + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.TAX_REFUND).with(security).addTo(manager);
        manager.add((IAction)new AbstractDialogAction(this, Messages.SecurityMenuStockSplit){

            @Override
            Dialog createDialog(Security security) {
                StockSplitWizard wizard = new StockSplitWizard(this.getClient(), security);
                return new WizardDialog(this.getShell(), (IWizard)wizard);
            }
        });
        manager.add((IAction)new AbstractDialogAction(this, Messages.SecurityMenuAddEvent){

            @Override
            Dialog createDialog(Security security) {
                CustomEventWizard wizard = new CustomEventWizard(this.getClient(), security);
                return new WizardDialog(this.getShell(), (IWizard)wizard);
            }
        });
        if (this.view.getClient().getActivePortfolios().size() > 1) {
            manager.add((IContributionItem)new Separator());
            new OpenDialogAction(this.view, Messages.SecurityMenuTransfer).type(SecurityTransferDialog.class).with(security).addTo(manager);
        }
        manager.add((IContributionItem)new Separator());
        new OpenDialogAction(this.view, String.valueOf(PortfolioTransaction.Type.DELIVERY_INBOUND.toString()) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.DELIVERY_INBOUND).with(security).addTo(manager);
        new OpenDialogAction(this.view, String.valueOf(PortfolioTransaction.Type.DELIVERY_OUTBOUND.toString()) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.DELIVERY_OUTBOUND).with(security).addTo(manager);
        new OpenDialogAction(this.view, Messages.InvestmentPlanMenuCreate).type(InvestmentPlanDialog.class).parameters(PortfolioTransaction.class).with(security).addTo(manager);
        manager.add((IContributionItem)new Separator());
    }

    private void deleteSecurity(IStructuredSelection selection) {
        boolean isDirty = false;
        ArrayList<Security> withTransactions = new ArrayList<Security>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Security security = (Security)obj;
            if (!security.getTransactions(this.getClient()).isEmpty()) {
                withTransactions.add(security);
            } else {
                this.getClient().removeSecurity(security);
                isDirty = true;
            }
            ++n2;
        }
        if (!withTransactions.isEmpty()) {
            String label = String.join((CharSequence)", ", withTransactions.stream().map(Security::getName).collect(Collectors.toList()));
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MsgDeletionNotPossible, (String)MessageFormat.format(Messages.MsgDeletionNotPossibleDetail, label));
        }
        if (isDirty) {
            this.markDirty();
            this.securities.setInput((Object)this.getClient().getSecurities());
        }
    }

    private abstract class AbstractDialogAction
    extends Action {
        public AbstractDialogAction(String text) {
            super(text);
        }

        public final void run() {
            Security security = (Security)((IStructuredSelection)SecuritiesTable.this.securities.getSelection()).getFirstElement();
            if (security == null) {
                return;
            }
            Dialog dialog = this.createDialog(security);
            if (dialog.open() == 0) {
                this.performFinish(security);
            }
        }

        protected void performFinish(Security security) {
            SecuritiesTable.this.markDirty();
            if (!SecuritiesTable.this.securities.getControl().isDisposed()) {
                boolean areFiltersAffected = false;
                ViewerFilter[] viewerFilterArray = SecuritiesTable.this.securities.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if (!filter.select((Viewer)SecuritiesTable.this.securities, (Object)security, (Object)security)) {
                        areFiltersAffected = true;
                    }
                    ++n2;
                }
                if (areFiltersAffected) {
                    SecuritiesTable.this.securities.refresh();
                } else {
                    SecuritiesTable.this.securities.refresh((Object)security, true);
                }
                SecuritiesTable.this.securities.setSelection(SecuritiesTable.this.securities.getSelection());
            }
        }

        abstract Dialog createDialog(Security var1);
    }

    private final class EditSecurityAction
    extends AbstractDialogAction {
        private EditSecurityAction() {
            super(Messages.SecurityMenuEditSecurity);
            this.setAccelerator(SWT.MOD1 | 0x45);
        }

        @Override
        Dialog createDialog(Security security) {
            return SecuritiesTable.this.view.make(EditSecurityDialog.class, security);
        }

        @Override
        protected void performFinish(Security security) {
            super.performFinish(security);
            SecuritiesTable.this.updateQuotes(security);
        }
    }

    private class LinkToPortfolioReport
    extends Action {
        private Security security;

        public LinkToPortfolioReport(Security security) {
            super(Messages.LabelLinkToPortfolioReportNet);
            this.security = security;
        }

        public void run() {
            InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.LabelInfo, "Portfolio Report URL", "https://www.portfolio-report.net/", newText -> ImportFromURLDropAdapter.URL_PATTERN.matcher(newText).matches() ? null : MessageFormat.format(Messages.DesktopAPIIllegalURL, newText));
            if (dlg.open() != 0) {
                return;
            }
            String url = dlg.getValue();
            Matcher matcher = ImportFromURLDropAdapter.URL_PATTERN.matcher(url);
            if (!matcher.matches()) {
                return;
            }
            String onlineId = matcher.group(1);
            try {
                Optional result = new PortfolioReportNet().getUpdatedValues(onlineId);
                if (!result.isPresent()) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)MessageFormat.format(Messages.MsgErrorNoInvestmentVehicleFoundAtURL, url));
                } else {
                    this.security.setOnlineId(onlineId);
                    PortfolioReportNet.updateWith((Security)this.security, (SecuritySearchProvider.ResultItem)((SecuritySearchProvider.ResultItem)result.get()));
                }
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
            }
        }
    }

    private static final class QuoteReportingPeriodLabelProvider
    extends OptionLabelProvider<ReportingPeriod> {
        private BiFunction<Object, ReportingPeriod, Double> valueProvider;

        public QuoteReportingPeriodLabelProvider(BiFunction<Object, ReportingPeriod, Double> valueProvider) {
            this.valueProvider = valueProvider;
        }

        @Override
        public String getText(Object e, ReportingPeriod option) {
            Double value = this.valueProvider.apply(e, option);
            if (value == null) {
                return null;
            }
            return String.format("%,.2f %%", value * 100.0);
        }

        @Override
        public Color getForeground(Object e, ReportingPeriod option) {
            Double value = this.valueProvider.apply(e, option);
            if (value == null) {
                return null;
            }
            if (value < 0.0) {
                return Colors.theme().redForeground();
            }
            if (value > 0.0) {
                return Colors.theme().greenForeground();
            }
            return null;
        }

        @Override
        public Image getImage(Object element, ReportingPeriod option) {
            Double value = this.valueProvider.apply(element, option);
            if (value == null) {
                return null;
            }
            if (value > 0.0) {
                return Images.GREEN_ARROW.image();
            }
            if (value < 0.0) {
                return Images.RED_ARROW.image();
            }
            return null;
        }
    }
}

