/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.function.ToDoubleFunction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.ScatterChart;
import name.abuchen.portfolio.ui.util.chart.ScatterChartCSVExporter;
import name.abuchen.portfolio.ui.views.AbstractHistoricView;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesChartLegend;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesConfigurator;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.IAxis;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ReturnsVolatilityChartView
extends AbstractHistoricView {
    private static final String KEY_USE_IRR = String.valueOf(ReturnsVolatilityChartView.class.getSimpleName()) + "-use-irr";
    private static final String KEY_RISK_METRIC = String.valueOf(ReturnsVolatilityChartView.class.getSimpleName()) + "-risk-metric";
    private boolean useIRR = false;
    private RiskMetric riskMetric = RiskMetric.VOLATILITY;
    private ScatterChart chart;
    private LocalResourceManager resources;
    private DataSeriesConfigurator configurator;
    private DataSeriesCache cache;

    @PostConstruct
    public void construct() {
        this.useIRR = this.getPreferenceStore().getBoolean(KEY_USE_IRR);
        String riskMetricKey = this.getPreferenceStore().getString(KEY_RISK_METRIC);
        if (riskMetricKey != null && !riskMetricKey.isEmpty()) {
            try {
                this.riskMetric = RiskMetric.valueOf(riskMetricKey);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @PreDestroy
    public void destroy() {
        this.getPreferenceStore().setValue(KEY_USE_IRR, this.useIRR);
        this.getPreferenceStore().setValue(KEY_RISK_METRIC, this.riskMetric.name());
    }

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelHistoricalReturnsAndVolatiltity;
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        super.addButtons(toolBar);
        toolBar.add((IContributionItem)new ExportDropDown());
        toolBar.add((IContributionItem)new DropDown(Messages.MenuConfigureChart, Images.CONFIG, 0, manager -> {
            manager.add((IAction)new LabelOnly(Messages.LabelPerformanceMetric));
            SimpleAction ttwror = new SimpleAction(Messages.ColumnTWROR, a -> {
                this.useIRR = false;
                IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
                yAxis.getTitle().setText(Messages.LabelPerformanceTTWROR);
                this.reportingPeriodUpdated();
            });
            ttwror.setChecked(!this.useIRR);
            manager.add((IAction)ttwror);
            SimpleAction irr = new SimpleAction(Messages.ColumnIRR, a -> {
                this.useIRR = true;
                IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
                yAxis.getTitle().setText(Messages.LabelPerformanceIRR);
                this.reportingPeriodUpdated();
            });
            irr.setChecked(this.useIRR);
            manager.add((IAction)irr);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new LabelOnly(Messages.LabelRiskMetric));
            RiskMetric[] riskMetricArray = RiskMetric.values();
            int n = riskMetricArray.length;
            int n2 = 0;
            while (n2 < n) {
                RiskMetric metric = riskMetricArray[n2];
                SimpleAction action = new SimpleAction(metric.toString(), a -> {
                    this.riskMetric = metric;
                    IAxis yAxis = this.chart.getAxisSet().getXAxis(0);
                    yAxis.getTitle().setText(metric.toString());
                    this.reportingPeriodUpdated();
                });
                action.setChecked(this.riskMetric == metric);
                manager.add((IAction)action);
                ++n2;
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new LabelOnly(Messages.LabelDataSeries));
            this.configurator.configMenuAboutToShow(manager);
        }));
    }

    protected Composite createBody(Composite parent) {
        this.cache = this.make(DataSeriesCache.class, new Object[0]);
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Display.getDefault().getSystemColor(1));
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.chart = new ScatterChart(composite);
        this.chart.getTitle().setVisible(false);
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setText(this.riskMetric.toString());
        xAxis.getTick().setFormat((Format)new DecimalFormat("0.##%"));
        IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText(this.useIRR ? Messages.LabelPerformanceIRR : Messages.LabelPerformanceTTWROR);
        yAxis.getTick().setFormat((Format)new DecimalFormat("0.##%"));
        this.configurator = new DataSeriesConfigurator(this, DataSeries.UseCase.RETURN_VOLATILITY);
        this.configurator.addListener(this::updateChart);
        this.configurator.setToolBarManager(this.getViewToolBarManager());
        DataSeriesChartLegend legend = new DataSeriesChartLegend(composite, this.configurator);
        this.updateTitle(String.valueOf(Messages.LabelHistoricalReturnsAndVolatiltity) + " (" + this.configurator.getConfigurationName() + ")");
        this.chart.getTitle().setText(this.getTitle());
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.chart);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 4).applyTo((Control)legend);
        this.setChartSeries();
        return composite;
    }

    @Override
    public void setFocus() {
        this.chart.adjustRange();
        this.chart.setFocus();
    }

    @Override
    public void reportingPeriodUpdated() {
        this.cache.clear();
        this.updateChart();
    }

    @Override
    public void notifyModelUpdated() {
        this.reportingPeriodUpdated();
    }

    private void updateChart() {
        try {
            this.updateTitle(String.valueOf(Messages.LabelHistoricalReturnsAndVolatiltity) + " (" + this.configurator.getConfigurationName() + ")");
            this.chart.suspendUpdate(true);
            this.chart.getTitle().setText(this.getTitle());
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            this.setChartSeries();
            this.chart.adjustRange();
        }
        finally {
            this.chart.suspendUpdate(false);
        }
        this.chart.redraw();
    }

    private void setChartSeries() {
        Interval interval = this.getReportingPeriod().toInterval(LocalDate.now());
        Lists.reverse(this.configurator.getSelectedDataSeries()).forEach(series -> {
            PerformanceIndex index = this.cache.lookup((DataSeries)series, interval);
            double risk = this.riskMetric.getRisk(index);
            double retrn = this.useIRR ? index.getPerformanceIRR() : index.getFinalAccumulatedPercentage();
            ILineSeries lineSeries = this.chart.addScatterSeries(new double[]{risk}, new double[]{retrn}, series.getLabel());
            Color color = this.resources.createColor(series.getColor());
            lineSeries.setLineColor(color);
            lineSeries.setSymbolColor(color);
            lineSeries.enableArea(series.isShowArea());
            lineSeries.setLineStyle(series.getLineStyle());
        });
    }

    private final class ExportDropDown
    extends DropDown
    implements IMenuListener {
        private ExportDropDown() {
            super(Messages.MenuExportData, Images.EXPORT, 0);
            this.setMenuListener(this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)new SimpleAction(Messages.MenuExportChartData, a -> {
                ScatterChartCSVExporter exporter = new ScatterChartCSVExporter(ReturnsVolatilityChartView.this.chart);
                exporter.setValueFormat(new DecimalFormat("0.##########%"));
                exporter.export(String.valueOf(ReturnsVolatilityChartView.this.getTitle()) + ".csv");
            }));
            for (DataSeries series : ReturnsVolatilityChartView.this.configurator.getSelectedDataSeries()) {
                manager.add((IAction)new SimpleAction(MessageFormat.format(Messages.LabelExport, series.getLabel()), a -> this.exportDataSeries(series)));
            }
            manager.add((IContributionItem)new Separator());
            ReturnsVolatilityChartView.this.chart.exportMenuAboutToShow(manager, ReturnsVolatilityChartView.this.getTitle());
        }

        private void exportDataSeries(final DataSeries series) {
            AbstractCSVExporter exporter = new AbstractCSVExporter(){

                @Override
                protected void writeToFile(File file) throws IOException {
                    PerformanceIndex index = ((ExportDropDown)ExportDropDown.this).ReturnsVolatilityChartView.this.cache.lookup(series, ReturnsVolatilityChartView.this.getReportingPeriod().toInterval(LocalDate.now()));
                    index.exportVolatilityData(file);
                }

                @Override
                protected Shell getShell() {
                    return ((ExportDropDown)ExportDropDown.this).ReturnsVolatilityChartView.this.chart.getShell();
                }
            };
            exporter.export(String.valueOf(ReturnsVolatilityChartView.this.getTitle()) + "_" + series.getLabel() + ".csv");
        }
    }

    private static enum RiskMetric {
        VOLATILITY(Messages.LabelVolatility, index -> index.getVolatility().getStandardDeviation()),
        SEMIVOLATILITY(Messages.LabelSemiVolatility, index -> index.getVolatility().getSemiDeviation());

        private String label;
        private ToDoubleFunction<PerformanceIndex> riskFunction;

        private RiskMetric(String label, ToDoubleFunction<PerformanceIndex> riskFunction) {
            this.label = label;
            this.riskFunction = riskFunction;
        }

        public double getRisk(PerformanceIndex index) {
            return this.riskFunction.applyAsDouble(index);
        }

        public String toString() {
            return this.label;
        }
    }
}

