/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import com.ibm.icu.text.MessageFormat;
import java.util.function.Predicate;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.CurrencyToStringConverter;
import name.abuchen.portfolio.ui.util.NumberVerifyListener;
import name.abuchen.portfolio.ui.util.StringToCurrencyConverter;
import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ValueEditingSupport
extends PropertyEditingSupport {
    private final StringToCurrencyConverter stringToLong;
    private final CurrencyToStringConverter longToString;
    private final Predicate<Number> validator;

    public ValueEditingSupport(Class<?> subjectType, String attributeName, Values<? extends Number> valueType, Predicate<Number> validator) {
        super(subjectType, attributeName);
        this.validator = validator;
        Class<?> propertyType = this.descriptor().getPropertyType();
        if (!Long.TYPE.isAssignableFrom(propertyType) && !Integer.TYPE.isAssignableFrom(propertyType)) {
            throw new UnsupportedOperationException(String.format("Property %s needs to be of type long or int to serve as decimal", attributeName));
        }
        this.stringToLong = new StringToCurrencyConverter(valueType);
        this.longToString = new CurrencyToStringConverter(valueType);
    }

    public ValueEditingSupport(Class<?> subjectType, String attributeName, Values<? extends Number> valueType) {
        this(subjectType, attributeName, valueType, null);
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        TextCellEditor textEditor = new TextCellEditor(composite);
        ((Text)textEditor.getControl()).setTextLimit(20);
        ((Text)textEditor.getControl()).addVerifyListener((VerifyListener)new NumberVerifyListener());
        return textEditor;
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        Number value = (Number)this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]);
        return this.longToString.convert(value.longValue());
    }

    @Override
    public void setValue(Object element, Object value) throws Exception {
        Object subject = this.adapt(element);
        Number newValue = this.stringToLong.convert(String.valueOf(value));
        if (Integer.TYPE.isAssignableFrom(this.descriptor().getPropertyType()) || Integer.class.isAssignableFrom(this.descriptor().getPropertyType())) {
            newValue = newValue.intValue();
        }
        if (this.validator != null && !this.validator.test(newValue)) {
            throw new IllegalArgumentException(MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{this.descriptor().getDisplayName()}));
        }
        Number oldValue = (Number)this.descriptor().getReadMethod().invoke(subject, new Object[0]);
        if (!newValue.equals(oldValue)) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

