/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;

public class StringEditingSupport
extends PropertyEditingSupport {
    private boolean isMandatory = false;

    public StringEditingSupport(Class<?> subjectType, String attributeName) {
        super(subjectType, attributeName);
        if (!String.class.isAssignableFrom(this.descriptor().getPropertyType())) {
            throw new IllegalArgumentException(String.format("Property %s needs to be of type string", attributeName));
        }
    }

    public StringEditingSupport setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
        return this;
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        String v = (String)this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]);
        return v != null ? v : "";
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        Object subject = this.adapt(element);
        String newValue = (String)value;
        String oldValue = (String)this.descriptor().getReadMethod().invoke(subject, new Object[0]);
        if (!(value.equals(oldValue) || this.isMandatory && newValue.trim().length() <= 0)) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

