/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.ConfigurationStore;
import name.abuchen.portfolio.ui.util.viewers.CellItemImageClickedListener;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupportWrapper;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ShowHideColumnHelper
implements IMenuListener,
ConfigurationStore.ConfigurationStoreOwner {
    static final String OPTIONS_KEY = String.valueOf(Column.class.getName()) + "_OPTION";
    private static final Pattern CONFIG_PATTERN = Pattern.compile("^([^=]*)=(?:([^\\|]*)\\|)?(?:(\\d*)\\$)?(\\d*)$");
    private final String identifier;
    private List<Column> columns = new ArrayList<Column>();
    private Map<String, Column> id2column = new HashMap<String, Column>();
    private IPreferenceStore preferences;
    private ConfigurationStore store;
    private List<Listener> listeners = new ArrayList<Listener>();
    private ViewerPolicy policy;
    private Menu contextMenu;

    public ShowHideColumnHelper(String identifier, IPreferenceStore preferences, TreeViewer viewer, TreeColumnLayout layout) {
        this(identifier, null, preferences, new TreeViewerPolicy(viewer, layout));
    }

    public ShowHideColumnHelper(String identifier, IPreferenceStore preferences, TableViewer viewer, TableColumnLayout layout) {
        this(identifier, null, preferences, viewer, layout);
    }

    public ShowHideColumnHelper(String identifier, Client client, IPreferenceStore preferences, TableViewer viewer, TableColumnLayout layout) {
        this(identifier, client, preferences, new TableViewerPolicy(viewer, layout));
    }

    private ShowHideColumnHelper(String identifier, Client client, IPreferenceStore preferences, ViewerPolicy policy) {
        this.identifier = identifier;
        this.policy = policy;
        this.preferences = preferences;
        if (client != null) {
            this.store = new ConfigurationStore(identifier, client, preferences, this);
            this.policy.setChangeListener(e -> this.store.updateActive(this.serialize()));
        }
        this.policy.getViewer().getControl().addDisposeListener(e -> this.widgetDisposed());
    }

    private void widgetDisposed() {
        if (this.store != null) {
            this.store.updateActive(this.serialize());
        } else {
            this.preferences.setValue(this.identifier, this.serialize());
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
    }

    public String getConfigurationName() {
        return this.store != null ? this.store.getActiveName() : null;
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void setToolBarManager(ToolBarManager toolBar) {
        if (this.store == null) {
            throw new NullPointerException("store");
        }
        this.store.setToolBarManager(toolBar);
    }

    public void showHideShowColumnsMenu(Shell shell) {
        if (this.contextMenu == null) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            this.contextMenu = menuMgr.createContextMenu((Control)shell);
        }
        this.contextMenu.setVisible(true);
    }

    public void menuAboutToShow(IMenuManager manager) {
        HashMap<Column, List<Object>> visible = new HashMap<Column, List<Object>>();
        Widget[] widgetArray = this.policy.getColumns();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget col = widgetArray[n2];
            Column column = (Column)col.getData(Column.class.getName());
            visible.computeIfAbsent(column, k -> new ArrayList()).add(col.getData(OPTIONS_KEY));
            ++n2;
        }
        HashMap<String, IMenuManager> groups = new HashMap<String, IMenuManager>();
        for (Column column : this.columns) {
            IMenuManager managerToAdd = manager;
            if (column.getGroupLabel() != null) {
                managerToAdd = groups.computeIfAbsent(column.getGroupLabel(), l -> {
                    MenuManager m = new MenuManager(l);
                    manager.add((IContributionItem)m);
                    return m;
                });
            }
            if (column.hasOptions()) {
                List options = visible.getOrDefault(column, Collections.emptyList());
                MenuManager subMenu = new MenuManager(column.getMenuLabel());
                for (Object option : column.getOptions().getOptions()) {
                    boolean isVisible = options.contains(option);
                    String label = column.getOptions().getMenuLabel(option);
                    this.addShowHideAction((IMenuManager)subMenu, column, label, isVisible, option);
                    if (!isVisible) continue;
                    options.remove(option);
                }
                for (Object option : options) {
                    String label = column.getOptions().getMenuLabel(option);
                    this.addShowHideAction((IMenuManager)subMenu, column, label, true, option);
                }
                if (column.getOptions().canCreateNewOptions()) {
                    this.addCreateOptionAction(subMenu, column);
                }
                managerToAdd.add((IContributionItem)subMenu);
                continue;
            }
            this.addShowHideAction(managerToAdd, column, column.getMenuLabel(), visible.containsKey(column), null);
        }
        this.addMenuAddGroup(groups, visible);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.MenuResetColumns){

            public void run() {
                ShowHideColumnHelper.this.doResetColumns();
            }
        });
    }

    private void addCreateOptionAction(MenuManager manager, final Column column) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.MenuCreateColumnConfig){

            public void run() {
                Object option = column.getOptions().createNewOption(Display.getCurrent().getActiveShell());
                if (option != null) {
                    ShowHideColumnHelper.this.policy.create(column, option, column.getDefaultSortDirection(), column.getDefaultWidth());
                    ShowHideColumnHelper.this.policy.getViewer().refresh(true);
                    if (ShowHideColumnHelper.this.store != null) {
                        ShowHideColumnHelper.this.store.updateActive(ShowHideColumnHelper.this.serialize());
                    }
                }
            }
        });
    }

    private void addShowHideAction(IMenuManager manager, final Column column, String label, final boolean isChecked, final Object option) {
        Action action = new Action(label){

            public void run() {
                if (isChecked) {
                    if (column.isRemovable()) {
                        ShowHideColumnHelper.this.destroyColumnWithOption(column, option);
                    }
                } else {
                    ShowHideColumnHelper.this.policy.create(column, option, column.getDefaultSortDirection(), column.getDefaultWidth());
                    ShowHideColumnHelper.this.policy.getViewer().refresh(true);
                }
                if (ShowHideColumnHelper.this.store != null) {
                    ShowHideColumnHelper.this.store.updateActive(ShowHideColumnHelper.this.serialize());
                }
            }
        };
        action.setChecked(isChecked);
        manager.add((IAction)action);
    }

    public void destroyColumnWithOption(Column column, Object option) {
        Widget[] widgetArray = this.policy.getColumns();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (column.equals(widget.getData(Column.class.getName())) && (option == null || option.equals(widget.getData(OPTIONS_KEY)))) {
                try {
                    this.policy.setRedraw(false);
                    Widget sortColumn = this.policy.getSortColumn();
                    if (widget.equals(sortColumn)) {
                        this.policy.getViewer().setComparator(null);
                    }
                    widget.dispose();
                    break;
                }
                finally {
                    this.policy.getViewer().refresh();
                    this.policy.setRedraw(true);
                }
            }
            ++n2;
        }
    }

    private void addMenuAddGroup(Map<String, IMenuManager> groups, final Map<Column, List<Object>> visible) {
        for (final Map.Entry<String, IMenuManager> entry : groups.entrySet()) {
            IMenuManager manager = entry.getValue();
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(Messages.MenuAddAll){

                public void run() {
                    ShowHideColumnHelper.this.doAddGroup((String)entry.getKey(), visible);
                }
            });
            manager.add((IAction)new Action(Messages.MenuRemoveAll){

                public void run() {
                    ShowHideColumnHelper.this.doRemoveGroup((String)entry.getKey());
                }
            });
        }
    }

    private void doAddGroup(String group, Map<Column, List<Object>> visible) {
        try {
            this.policy.setRedraw(false);
            for (Column column : this.columns) {
                if (!group.equals(column.getGroupLabel()) || visible.containsKey(column)) continue;
                if (column.hasOptions()) {
                    for (Object element : column.getOptions().getOptions()) {
                        this.policy.create(column, element, column.getDefaultSortDirection(), column.getDefaultWidth());
                    }
                    continue;
                }
                this.policy.create(column, null, column.getDefaultSortDirection(), column.getDefaultWidth());
            }
        }
        finally {
            this.policy.getViewer().refresh();
            this.policy.setRedraw(true);
        }
    }

    private void doRemoveGroup(String group) {
        try {
            this.policy.setRedraw(false);
            Widget[] widgetArray = this.policy.getColumns();
            int n = widgetArray.length;
            int n2 = 0;
            while (n2 < n) {
                Widget col = widgetArray[n2];
                Column column = (Column)col.getData(Column.class.getName());
                if (group.equals(column.getGroupLabel())) {
                    col.dispose();
                }
                ++n2;
            }
        }
        finally {
            this.policy.getViewer().refresh();
            this.policy.setRedraw(true);
        }
    }

    public void addColumn(Column column) {
        if (column.getId() == null) {
            column.setId(Integer.toString(this.columns.size()));
        }
        this.columns.add(column);
        this.id2column.put(column.getId(), column);
    }

    public void createColumns() {
        this.createFromColumnConfig();
        if (this.policy.getColumnCount() == 0) {
            this.columns.stream().filter(c -> c.isVisible()).forEach(c -> this.policy.create((Column)c, null, c.getDefaultSortDirection(), c.getDefaultWidth()));
        }
    }

    private void createFromColumnConfig() {
        String configInPreferences = this.preferences.getString(this.identifier);
        if (this.store != null && !configInPreferences.isEmpty()) {
            this.preferences.setToDefault(this.identifier);
            this.preferences.setValue("__backup__" + this.identifier, configInPreferences);
            this.store.insertMigratedConfiguration(configInPreferences);
        }
        String config = this.store != null ? this.store.getActive() : configInPreferences;
        this.createFromColumnConfig(config);
    }

    private void createFromColumnConfig(String config) {
        if (config == null || config.trim().length() == 0) {
            return;
        }
        try {
            this.policy.setRedraw(false);
            this.policy.getViewer().setComparator(null);
            int count = this.policy.getColumnCount();
            StringTokenizer tokens = new StringTokenizer(config, ";");
            while (tokens.hasMoreTokens()) {
                try {
                    String d;
                    Column col;
                    Matcher matcher = CONFIG_PATTERN.matcher(tokens.nextToken());
                    if (!matcher.matches() || (col = this.id2column.get(matcher.group(1))) == null) continue;
                    Object option = null;
                    if (col.hasOptions()) {
                        String o = matcher.group(2);
                        option = col.getOptions().valueOf(o);
                        if (option == null) continue;
                    }
                    Integer direction = (d = matcher.group(3)) != null ? Integer.valueOf(Integer.parseInt(d)) : null;
                    int width = Integer.parseInt(matcher.group(4));
                    this.policy.create(col, option, direction, width);
                }
                catch (RuntimeException e) {
                    PortfolioPlugin.log(e);
                }
            }
            int ii = 0;
            while (ii < count) {
                this.policy.getColumn(0).dispose();
                ++ii;
            }
        }
        finally {
            this.policy.setRedraw(true);
        }
    }

    private void doResetColumns() {
        try {
            this.policy.setRedraw(false);
            this.policy.getViewer().setComparator(null);
            int count = this.policy.getColumnCount();
            for (Column column : this.columns) {
                if (!column.isVisible() || column.hasOptions()) continue;
                this.policy.create(column, null, column.getDefaultSortDirection(), column.getDefaultWidth());
            }
            int ii = 0;
            while (ii < count) {
                this.policy.getColumn(0).dispose();
                ++ii;
            }
        }
        finally {
            this.policy.getViewer().refresh();
            this.policy.setRedraw(true);
        }
        if (this.store != null) {
            this.store.updateActive(this.serialize());
        }
    }

    private String serialize() {
        StringBuilder buf = new StringBuilder();
        Widget sortedColumn = this.policy.getSortColumn();
        int[] nArray = this.policy.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Widget col = this.policy.getColumn(index);
            Column column = (Column)col.getData(Column.class.getName());
            buf.append(column.getId()).append('=');
            if (column.hasOptions()) {
                buf.append(column.getOptions().toString(col.getData(OPTIONS_KEY))).append('|');
            }
            if (col.equals(sortedColumn)) {
                buf.append(this.policy.getSortDirection()).append('$');
            }
            buf.append(this.policy.getWidth(col)).append(';');
            ++n2;
        }
        return buf.toString();
    }

    @Override
    public void beforeConfigurationPicked() {
        this.store.updateActive(this.serialize());
    }

    @Override
    public void onConfigurationPicked(String data) {
        if (data == null) {
            this.doResetColumns();
        } else {
            this.createFromColumnConfig(data);
        }
        this.listeners.stream().forEach(l -> l.onConfigurationPicked());
        this.policy.getViewer().refresh();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onConfigurationPicked();
    }

    private static class TableViewerPolicy
    extends ViewerPolicy {
        private TableViewer table;
        private TableColumnLayout layout;

        public TableViewerPolicy(TableViewer table, TableColumnLayout layout) {
            this.table = table;
            this.layout = layout;
        }

        @Override
        public ColumnViewer getViewer() {
            return this.table;
        }

        @Override
        public int getColumnCount() {
            return this.table.getTable().getColumnCount();
        }

        @Override
        public Widget[] getColumns() {
            return this.table.getTable().getColumns();
        }

        @Override
        public Widget getColumn(int index) {
            return this.table.getTable().getColumn(index);
        }

        @Override
        public Widget getSortColumn() {
            return this.table.getTable().getSortColumn();
        }

        @Override
        Widget getColumnWidget(ViewerColumn column) {
            return ((TableViewerColumn)column).getColumn();
        }

        @Override
        public int[] getColumnOrder() {
            return this.table.getTable().getColumnOrder();
        }

        @Override
        public int getSortDirection() {
            return this.table.getTable().getSortDirection();
        }

        @Override
        public int getWidth(Widget col) {
            return ((TableColumn)col).getWidth();
        }

        @Override
        public void create(Column column, Object option, Integer direction, int width) {
            TableViewerColumn col = new TableViewerColumn(this.table, column.getStyle());
            TableColumn tableColumn = col.getColumn();
            tableColumn.setMoveable(true);
            tableColumn.setWidth(width);
            tableColumn.setData(Column.class.getName(), (Object)column);
            if (column.getImage() != null) {
                tableColumn.setImage(column.getImage().image());
            }
            if (option == null) {
                tableColumn.setText(column.getLabel());
                tableColumn.setToolTipText(this.createToolTip(column.getLabel(), column.getDescription(), column.getMenuLabel()));
            } else {
                String text = column.getOptions().getColumnLabel(option);
                tableColumn.setText(text);
                String description = column.getOptions().getDescription(option);
                tableColumn.setToolTipText(this.createToolTip(text, description, column.getMenuLabel()));
                tableColumn.setData(OPTIONS_KEY, option);
            }
            this.layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(width));
            this.setCommonParameters(column, (ViewerColumn)col, direction);
            if (column.getLabelProvider() instanceof CellItemImageClickedListener) {
                this.setupImageClickedListener(column, tableColumn);
            }
        }

        private void setupImageClickedListener(Column column, TableColumn tableColumn) {
            org.eclipse.swt.widgets.Listener listener = event -> {
                int columnIndex = this.table.getTable().indexOf(tableColumn);
                if (columnIndex == -1) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                TableItem tableItem = this.table.getTable().getItem(pt);
                if (tableItem == null) {
                    return;
                }
                Rectangle rect = tableItem.getImageBounds(columnIndex);
                if (rect.contains(pt)) {
                    ((CellItemImageClickedListener)column.getLabelProvider()).onImageClicked(tableItem.getData());
                }
            };
            this.table.getTable().addListener(4, listener);
            tableColumn.addDisposeListener(e -> this.table.getTable().removeListener(4, listener));
        }
    }

    private static class TreeViewerPolicy
    extends ViewerPolicy {
        private TreeViewer tree;
        private TreeColumnLayout layout;

        public TreeViewerPolicy(TreeViewer tree, TreeColumnLayout layout) {
            this.tree = tree;
            this.layout = layout;
        }

        @Override
        public ColumnViewer getViewer() {
            return this.tree;
        }

        @Override
        public int getColumnCount() {
            return this.tree.getTree().getColumnCount();
        }

        @Override
        public Widget[] getColumns() {
            return this.tree.getTree().getColumns();
        }

        @Override
        public Widget getColumn(int index) {
            return this.tree.getTree().getColumn(index);
        }

        @Override
        public Widget getSortColumn() {
            return this.tree.getTree().getSortColumn();
        }

        @Override
        Widget getColumnWidget(ViewerColumn column) {
            return ((TreeViewerColumn)column).getColumn();
        }

        @Override
        public int[] getColumnOrder() {
            return this.tree.getTree().getColumnOrder();
        }

        @Override
        public int getSortDirection() {
            return this.tree.getTree().getSortDirection();
        }

        @Override
        public int getWidth(Widget col) {
            return ((TreeColumn)col).getWidth();
        }

        @Override
        public void create(Column column, Object option, Integer direction, int width) {
            TreeViewerColumn col = new TreeViewerColumn(this.tree, column.getStyle());
            TreeColumn treeColumn = col.getColumn();
            treeColumn.setMoveable(true);
            treeColumn.setWidth(width);
            treeColumn.setData(Column.class.getName(), (Object)column);
            if (column.getImage() != null) {
                treeColumn.setImage(column.getImage().image());
            }
            if (option == null) {
                treeColumn.setText(column.getLabel());
                treeColumn.setToolTipText(this.createToolTip(column.getLabel(), column.getDescription(), column.getMenuLabel()));
            } else {
                String text = column.getOptions().getColumnLabel(option);
                treeColumn.setText(text);
                String description = column.getOptions().getDescription(option);
                treeColumn.setToolTipText(this.createToolTip(text, description, column.getMenuLabel()));
                treeColumn.setData(OPTIONS_KEY, option);
            }
            this.layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(width));
            this.setCommonParameters(column, (ViewerColumn)col, direction);
            if (column.getLabelProvider() instanceof CellItemImageClickedListener) {
                this.setupImageClickedListener(column, treeColumn);
            }
        }

        private void setupImageClickedListener(Column column, TreeColumn treeColumn) {
            org.eclipse.swt.widgets.Listener listener = event -> {
                int columnIndex = this.tree.getTree().indexOf(treeColumn);
                if (columnIndex == -1) {
                    return;
                }
                Point pt = new Point(event.x, event.y);
                TreeItem treeItem = this.tree.getTree().getItem(pt);
                if (treeItem == null) {
                    return;
                }
                Rectangle rect = treeItem.getImageBounds(columnIndex);
                if (rect.contains(pt)) {
                    ((CellItemImageClickedListener)column.getLabelProvider()).onImageClicked(treeItem.getData());
                }
            };
            this.tree.getTree().addListener(4, listener);
            treeColumn.addDisposeListener(e -> this.tree.getTree().removeListener(4, listener));
        }
    }

    private static abstract class ViewerPolicy {
        private org.eclipse.swt.widgets.Listener changeListener;

        private ViewerPolicy() {
        }

        abstract ColumnViewer getViewer();

        abstract int getColumnCount();

        abstract Widget[] getColumns();

        abstract Widget getColumn(int var1);

        abstract Widget getSortColumn();

        abstract Widget getColumnWidget(ViewerColumn var1);

        abstract int[] getColumnOrder();

        abstract int getSortDirection();

        abstract int getWidth(Widget var1);

        abstract void create(Column var1, Object var2, Integer var3, int var4);

        void setCommonParameters(Column column, ViewerColumn viewerColumn, Integer direction) {
            viewerColumn.setLabelProvider(column.getLabelProvider());
            if (column.getSorter() != null) {
                if (direction != null) {
                    column.getSorter().attachTo(this.getViewer(), viewerColumn, direction);
                } else {
                    column.getSorter().attachTo(this.getViewer(), viewerColumn);
                }
                if (this.changeListener != null) {
                    this.getColumnWidget(viewerColumn).addListener(13, this.changeListener);
                }
            }
            if (column.getEditingSupport() != null) {
                viewerColumn.setEditingSupport((EditingSupport)new ColumnEditingSupportWrapper(this.getViewer(), column.getEditingSupport()));
            }
            if (this.changeListener != null) {
                this.getColumnWidget(viewerColumn).addListener(11, this.changeListener);
                this.getColumnWidget(viewerColumn).addListener(10, this.changeListener);
            }
        }

        void setRedraw(boolean redraw) {
            this.getViewer().getControl().setRedraw(redraw);
        }

        public void setChangeListener(org.eclipse.swt.widgets.Listener changeListener) {
            this.changeListener = changeListener;
        }

        String createToolTip(String label, String description, String menuLabel) {
            if (description != null) {
                return String.valueOf(label) + "\n\n" + this.wordwrap(description);
            }
            if (menuLabel != null && !label.equals(menuLabel)) {
                return String.valueOf(label) + "\n\n" + menuLabel;
            }
            return label;
        }

        String wordwrap(String text) {
            return "win32".equals(Platform.getOS()) ? TextUtil.wordwrap((String)text) : text;
        }
    }
}

