/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.function.Function;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class NumberColorLabelProvider<N extends Number>
extends ColumnLabelProvider {
    private final Values<N> format;
    private final Function<Object, N> label;
    private final Function<Object, String> tooltip;

    public NumberColorLabelProvider(Values<N> format, Function<Object, N> label) {
        this(format, label, null);
    }

    public NumberColorLabelProvider(Values<N> format, Function<Object, N> label, Function<Object, String> tooltip) {
        this.format = format;
        this.label = label;
        this.tooltip = tooltip;
    }

    public Color getForeground(Object element) {
        Number value = (Number)this.label.apply(element);
        if (value == null) {
            return null;
        }
        return value.doubleValue() >= 0.0 ? Colors.theme().greenForeground() : Colors.theme().redForeground();
    }

    public Image getImage(Object element) {
        Number value = (Number)this.label.apply(element);
        if (value == null) {
            return null;
        }
        return value.doubleValue() >= 0.0 ? Images.GREEN_ARROW.image() : Images.RED_ARROW.image();
    }

    public String getText(Object element) {
        Number value = (Number)this.label.apply(element);
        if (value == null) {
            return null;
        }
        return this.format.format((Object)value);
    }

    public String getToolTipText(Object element) {
        return this.tooltip != null ? this.tooltip.apply(element) : null;
    }
}

