/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trail.Trail;
import name.abuchen.portfolio.snapshot.trail.TrailProvider;
import name.abuchen.portfolio.snapshot.trail.TrailRecord;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class MoneyTrailToolTipSupport
extends ColumnViewerToolTipSupport {
    protected MoneyTrailToolTipSupport(ColumnViewer viewer, int style, boolean manualActivation) {
        super(viewer, style, manualActivation);
    }

    public static final void enableFor(ColumnViewer viewer, int style) {
        new MoneyTrailToolTipSupport(viewer, style, false);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
        if (cell == null) {
            return super.createViewerToolTipContentArea(event, cell, parent);
        }
        Object element = cell.getElement();
        if (!(element instanceof TrailProvider)) {
            return super.createViewerToolTipContentArea(event, cell, parent);
        }
        Optional trail = ((TrailProvider)element).explain(this.getText(event));
        if (!trail.isPresent()) {
            return super.createViewerToolTipContentArea(event, cell, parent);
        }
        return this.createTrailTable(parent, (Trail)trail.get());
    }

    public boolean isHideOnMouseDown() {
        return false;
    }

    private Composite createTrailTable(Composite parent, Trail trail) {
        int depth = trail.getDepth();
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.INFO_TOOLTIP_BACKGROUND);
        GridLayoutFactory.swtDefaults().numColumns(depth + 3).applyTo(composite);
        Label heading = new Label(composite, 0);
        heading.setBackground(composite.getBackground());
        heading.setText(trail.getLabel());
        GridDataFactory.fillDefaults().span(depth + 3, 1).applyTo((Control)heading);
        this.addRow(composite, trail.getRecord(), depth - 1, depth);
        return composite;
    }

    private Label addRow(Composite composite, TrailRecord trail, int level, int depth) {
        ArrayList<Label> inputs = new ArrayList<Label>();
        for (TrailRecord child : trail.getInputs()) {
            inputs.add(this.addRow(composite, child, level - 1, depth));
        }
        Label date = new Label(composite, 0);
        date.setBackground(composite.getBackground());
        if (trail.getDate() != null) {
            date.setText(Values.Date.format((Object)trail.getDate()));
        }
        Label label = new Label(composite, 0);
        label.setBackground(composite.getBackground());
        label.setText(trail.getLabel());
        Label shares = new Label(composite, 131072);
        shares.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().applyTo((Control)shares);
        if (trail.getShares() != null) {
            shares.setText(Values.Share.format((Object)trail.getShares()));
        }
        Label answer = null;
        int index = 0;
        while (index < depth) {
            Label column = new Label(composite, 131072);
            column.setBackground(composite.getBackground());
            GridDataFactory.fillDefaults().applyTo((Control)column);
            if (index == level) {
                answer = column;
                column.setText(trail.getValue() != null ? Values.Money.format(trail.getValue()) : Messages.LabelNotAvailable);
                this.highlight(Arrays.asList(label, column), inputs);
            }
            ++index;
        }
        return answer;
    }

    private void highlight(final List<Label> outputs, final List<Label> inputs) {
        if (inputs.isEmpty()) {
            return;
        }
        outputs.forEach(label -> label.addMouseTrackListener(new MouseTrackListener(){
            private Color background = Colors.INFO_TOOLTIP_BACKGROUND;

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                outputs.forEach(l -> l.setBackground(this.background));
                inputs.forEach(l -> l.setBackground(this.background));
            }

            public void mouseEnter(MouseEvent e) {
                this.background = ((Label)outputs.get(0)).getBackground();
                outputs.forEach(l -> l.setBackground(Colors.ICON_ORANGE));
                inputs.forEach(l -> l.setBackground(Colors.ICON_GREEN));
            }
        }));
    }
}

