/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DateTimeEditingSupport
extends PropertyEditingSupport {
    private static final DateTimeFormatter[] timeFormatters = new DateTimeFormatter[]{DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG), DateTimeFormatter.ofPattern("d.M.yyyy HH:mm"), DateTimeFormatter.ofPattern("d.M.yy HH:mm"), DateTimeFormatter.ISO_DATE_TIME};
    private static final DateTimeFormatter[] dateFormatters = new DateTimeFormatter[]{DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), DateTimeFormatter.ofPattern("d.M.yyyy"), DateTimeFormatter.ofPattern("d.M.yy"), DateTimeFormatter.ISO_DATE};

    public DateTimeEditingSupport(Class<?> subjectType, String attributeName) {
        super(subjectType, attributeName);
        if (!LocalDateTime.class.isAssignableFrom(this.descriptor().getPropertyType())) {
            throw new IllegalArgumentException(String.format("Property %s needs to be of type LocalDateTime", attributeName));
        }
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        TextCellEditor textEditor = new TextCellEditor(composite);
        ((Text)textEditor.getControl()).setTextLimit(20);
        return textEditor;
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        LocalDateTime date = (LocalDateTime)this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]);
        return Values.DateTime.format((Object)date);
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        DateTimeFormatter formatter;
        String inputValue = String.valueOf(value).trim();
        LocalDateTime newValue = null;
        DateTimeFormatter[] dateTimeFormatterArray = timeFormatters;
        int n = timeFormatters.length;
        int n2 = 0;
        while (n2 < n) {
            formatter = dateTimeFormatterArray[n2];
            try {
                newValue = LocalDateTime.parse(inputValue, formatter);
                break;
            }
            catch (DateTimeParseException dateTimeParseException) {
                ++n2;
            }
        }
        if (newValue == null) {
            dateTimeFormatterArray = dateFormatters;
            n = dateFormatters.length;
            n2 = 0;
            while (n2 < n) {
                formatter = dateTimeFormatterArray[n2];
                try {
                    newValue = LocalDate.parse(inputValue, formatter).atStartOfDay();
                    break;
                }
                catch (DateTimeParseException dateTimeParseException) {
                    ++n2;
                }
            }
        }
        if (newValue == null) {
            throw new IllegalArgumentException(MessageFormat.format((String)Messages.MsgErrorNotAValidDate, (Object[])new Object[]{value}));
        }
        Object subject = this.adapt(element);
        LocalDateTime oldValue = (LocalDateTime)this.descriptor().getReadMethod().invoke(subject, new Object[0]);
        if (!newValue.equals(oldValue)) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

