/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Quote;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;

public final class ColumnViewerSorter {
    private Comparator<Object> comparator;

    private ColumnViewerSorter(Comparator<Object> comparator) {
        this.comparator = comparator;
    }

    public static ColumnViewerSorter create(Class<?> clazz, String ... attributes) {
        ArrayList<Comparator<Object>> comparators = new ArrayList<Comparator<Object>>();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            comparators.add(new BeanComparator(clazz, attribute));
            ++n2;
        }
        return new ColumnViewerSorter(comparators.size() == 1 ? (Comparator)comparators.get(0) : new ChainedComparator(comparators));
    }

    public static ColumnViewerSorter create(Function<Object, Comparable<?>> valueProvider) {
        return ColumnViewerSorter.create(new ValueProviderComparator(valueProvider));
    }

    public static ColumnViewerSorter createIgnoreCase(Function<Object, String> valueProvider) {
        return ColumnViewerSorter.create(new StringValueProviderComparator(valueProvider));
    }

    public static ColumnViewerSorter create(Comparator<? extends Object> comparator) {
        return new ColumnViewerSorter(comparator);
    }

    public ColumnViewerSorter wrap(UnaryOperator<Comparator<Object>> provider) {
        this.comparator = (Comparator)provider.apply(this.comparator);
        return this;
    }

    public void attachTo(Column column) {
        column.setSorter(this);
    }

    public void attachTo(Column column, int direction) {
        column.setSorter(this, direction);
    }

    public void attachTo(ColumnViewer viewer, ViewerColumn column) {
        this.attachTo(viewer, column, 0);
    }

    public void attachTo(ColumnViewer viewer, ViewerColumn column, boolean makeDefault) {
        this.attachTo(viewer, column, makeDefault ? 1024 : 0);
    }

    public void attachTo(ColumnViewer viewer, ViewerColumn column, int direction) {
        ViewerSorter x = new ViewerSorter(viewer, column, this.comparator);
        if (direction != 0) {
            x.setSorter(direction);
        }
    }

    private static final class BeanComparator
    implements Comparator<Object> {
        private final Class<?> clazz;
        private final Method method;
        private final int type;

        private BeanComparator(Class<?> clazz, String attribute) {
            this.clazz = clazz;
            this.method = this.determineReadMethod(clazz, attribute);
            Class<Object> returnType = this.method.getReturnType();
            this.type = returnType.equals(Object.class) ? 0 : (returnType.isAssignableFrom(String.class) ? 1 : (returnType.isAssignableFrom(Enum.class) ? 2 : (returnType.isAssignableFrom(Integer.class) || returnType.isAssignableFrom(Integer.TYPE) ? 3 : (returnType.isAssignableFrom(Double.class) || returnType.isAssignableFrom(Double.TYPE) ? 4 : (returnType.isAssignableFrom(Date.class) ? 5 : (returnType.isAssignableFrom(Long.class) || returnType.isAssignableFrom(Long.TYPE) ? 6 : (returnType.isAssignableFrom(Boolean.class) || returnType.isAssignableFrom(Boolean.TYPE) ? 7 : (returnType.isAssignableFrom(Money.class) ? 8 : (returnType.isAssignableFrom(Quote.class) ? 9 : 0)))))))));
        }

        private Method determineReadMethod(Class<?> clazz, String attribute) {
            String camelCaseAttribute = String.valueOf(Character.toUpperCase(attribute.charAt(0))) + attribute.substring(1);
            try {
                return clazz.getMethod("get" + camelCaseAttribute, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return clazz.getMethod("is" + camelCaseAttribute, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    PortfolioPlugin.log(Arrays.asList(e, e1));
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object attribute2;
            Object attribute1;
            block21: {
                block20: {
                    block19: {
                        Object object1 = Adaptor.adapt(this.clazz, (Object)o1);
                        Object object2 = Adaptor.adapt(this.clazz, (Object)o2);
                        if (object1 == null && object2 == null) {
                            return 0;
                        }
                        if (object1 == null) {
                            return -1;
                        }
                        if (object2 == null) {
                            return 1;
                        }
                        attribute1 = this.method.invoke(object1, new Object[0]);
                        attribute2 = this.method.invoke(object2, new Object[0]);
                        if (attribute1 != null || attribute2 != null) break block19;
                        return 0;
                    }
                    if (attribute1 != null) break block20;
                    return -1;
                }
                if (attribute2 != null) break block21;
                return 1;
            }
            try {
                switch (this.type) {
                    case 1: {
                        return ((String)attribute1).compareToIgnoreCase((String)attribute2);
                    }
                    case 2: {
                        return ((Enum)attribute2).name().compareTo(((Enum)attribute2).name());
                    }
                    case 3: {
                        return ((Integer)attribute1).compareTo((Integer)attribute2);
                    }
                    case 4: {
                        return ((Double)attribute1).compareTo((Double)attribute2);
                    }
                    case 5: {
                        return ((Date)attribute1).compareTo((Date)attribute2);
                    }
                    case 6: {
                        return ((Long)attribute1).compareTo((Long)attribute2);
                    }
                    case 7: {
                        return ((Boolean)attribute1).compareTo((Boolean)attribute2);
                    }
                    case 8: {
                        return ((Money)attribute1).compareTo((Money)attribute2);
                    }
                    case 9: {
                        return ((Quote)attribute1).compareTo((Quote)attribute2);
                    }
                }
                return String.valueOf(attribute1).compareToIgnoreCase(String.valueOf(attribute2));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private static final class ChainedComparator
    implements Comparator<Object> {
        private final List<Comparator<Object>> comparators;

        private ChainedComparator(List<Comparator<Object>> comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Object o1, Object o2) {
            for (Comparator<Object> c : this.comparators) {
                int result = c.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    public static final class SortingContext {
        private static final String OPTION = "option";
        private static final String DIRECTION = "direction";
        private static final ThreadLocal<Map<String, Object>> MAP = ThreadLocal.withInitial(HashMap::new);

        private SortingContext() {
        }

        static void setSortDirection(int direction) {
            MAP.get().put(DIRECTION, direction);
        }

        public static int getSortDirection() {
            Object direction = MAP.get().get(DIRECTION);
            return direction == null ? 1024 : (Integer)direction;
        }

        static void setOption(Object option) {
            MAP.get().put(OPTION, option);
        }

        public static Object getColumnOption() {
            return MAP.get().get(OPTION);
        }

        static void clear() {
            MAP.get().clear();
        }
    }

    private static final class StringValueProviderComparator
    implements Comparator<Object> {
        private final Function<Object, String> valueProvider;

        public StringValueProviderComparator(Function<Object, String> valueProvider) {
            this.valueProvider = valueProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String v1 = this.valueProvider.apply(o1);
            String v2 = this.valueProvider.apply(o2);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareToIgnoreCase(v2);
        }
    }

    private static final class ValueProviderComparator
    implements Comparator<Object> {
        private final Function<Object, Comparable<?>> valueProvider;

        public ValueProviderComparator(Function<Object, Comparable<?>> valueProvider) {
            this.valueProvider = valueProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Comparable<?> v1 = this.valueProvider.apply(o1);
            Comparable<?> v2 = this.valueProvider.apply(o2);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }
    }

    private static final class ViewerSorter
    extends ViewerComparator {
        private ColumnViewer columnViewer;
        private ViewerColumn viewerColumn;
        private Comparator<Object> comparator;
        private int direction = 1024;

        public ViewerSorter(ColumnViewer columnViewer, ViewerColumn viewerColumn, Comparator<Object> comparator) {
            TableColumn widget;
            this.columnViewer = columnViewer;
            this.viewerColumn = viewerColumn;
            this.comparator = comparator;
            if (viewerColumn instanceof TableViewerColumn) {
                widget = ((TableViewerColumn)viewerColumn).getColumn();
            } else if (viewerColumn instanceof TreeViewerColumn) {
                widget = ((TreeViewerColumn)viewerColumn).getColumn();
            } else {
                throw new UnsupportedOperationException();
            }
            widget.addListener(13, event -> this.handleSelectionEvent());
        }

        private void handleSelectionEvent() {
            boolean columnIsCurrentlySorted;
            if (this.viewerColumn instanceof TableViewerColumn) {
                columnIsCurrentlySorted = ((TableViewer)this.columnViewer).getTable().getSortColumn() == ((TableViewerColumn)this.viewerColumn).getColumn();
            } else if (this.viewerColumn instanceof TreeViewerColumn) {
                columnIsCurrentlySorted = ((TreeViewer)this.columnViewer).getTree().getSortColumn() == ((TreeViewerColumn)this.viewerColumn).getColumn();
            } else {
                throw new IllegalArgumentException();
            }
            if (columnIsCurrentlySorted) {
                this.setSorter(this.direction == 1024 ? 128 : 1024);
            } else {
                this.setSorter(1024);
            }
        }

        private void setSorter(int direction) {
            this.direction = direction;
            if (this.viewerColumn instanceof TableViewerColumn) {
                TableColumn c = ((TableViewerColumn)this.viewerColumn).getColumn();
                c.getParent().setSortColumn(c);
                c.getParent().setSortDirection(direction);
            } else if (this.viewerColumn instanceof TreeViewerColumn) {
                TreeColumn c = ((TreeViewerColumn)this.viewerColumn).getColumn();
                c.getParent().setSortColumn(c);
                c.getParent().setSortDirection(direction);
            }
            if (this.columnViewer.getComparator() == this) {
                this.columnViewer.refresh();
            } else {
                this.columnViewer.setComparator((ViewerComparator)this);
            }
        }

        public int compare(Viewer viewer, Object element1, Object element2) {
            try {
                int dir;
                this.setupSortingContext();
                int n = dir = this.direction == 1024 ? 1 : -1;
                if (element1 == null && element2 == null) {
                    return 0;
                }
                if (element1 == null) {
                    int n2 = dir;
                    return n2;
                }
                if (element2 == null) {
                    int n3 = -dir;
                    return n3;
                }
                int n4 = dir * this.comparator.compare(element1, element2);
                return n4;
            }
            finally {
                SortingContext.clear();
            }
        }

        private void setupSortingContext() {
            SortingContext.setSortDirection(this.direction);
            Object option = null;
            if (this.viewerColumn instanceof TableViewerColumn) {
                option = ((TableViewerColumn)this.viewerColumn).getColumn().getData(ShowHideColumnHelper.OPTIONS_KEY);
            } else if (this.viewerColumn instanceof TreeViewerColumn) {
                option = ((TreeViewerColumn)this.viewerColumn).getColumn().getData(ShowHideColumnHelper.OPTIONS_KEY);
            }
            SortingContext.setOption(option);
        }
    }
}

