/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Attributes;
import name.abuchen.portfolio.ui.util.NumberVerifyListener;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AttributeEditingSupport
extends ColumnEditingSupport {
    protected final AttributeType attribute;

    public AttributeEditingSupport(AttributeType attribute) {
        this.attribute = attribute;
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        TextCellEditor textEditor = new TextCellEditor(composite);
        if (this.attribute.isNumber()) {
            ((Text)textEditor.getControl()).addVerifyListener((VerifyListener)new NumberVerifyListener(true));
        }
        return textEditor;
    }

    @Override
    public boolean canEdit(Object element) {
        Attributable attributable = (Attributable)Adaptor.adapt(Attributable.class, (Object)element);
        if (attributable == null) {
            return false;
        }
        return this.attribute.supports(attributable.getClass());
    }

    @Override
    public Object getValue(Object element) throws Exception {
        Attributes attribs = ((Attributable)Adaptor.adapt(Attributable.class, (Object)element)).getAttributes();
        return this.attribute.getConverter().toString(attribs.get(this.attribute));
    }

    @Override
    public void setValue(Object element, Object value) throws Exception {
        Attributes attribs = ((Attributable)Adaptor.adapt(Attributable.class, (Object)element)).getAttributes();
        Object newValue = this.attribute.getConverter().fromString(String.valueOf(value));
        Object oldValue = attribs.get(this.attribute);
        if (newValue != null && !newValue.equals(oldValue) || newValue == null && attribs.exists(this.attribute)) {
            attribs.put(this.attribute, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

