/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.swt;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SashLayout
extends Layout {
    private static final int SASH_WIDTH = 10;
    private static final int MIN_WIDHT = 20;
    private final boolean isHorizontal;
    private final boolean isBeginning;
    private Composite host;
    private Label divider;
    private Rectangle sash = new Rectangle(0, 0, 1, 1);
    private boolean isDragging = false;

    public SashLayout(final Composite host, int style) {
        this.host = host;
        this.host.setBackground(Display.getDefault().getSystemColor(1));
        this.isHorizontal = (style & 0x100) == 256;
        this.isBeginning = (style & 1) == 1;
        this.divider = new Label(host, 0);
        this.divider.setImage(this.isHorizontal ? Images.HANDLE_NS.image() : Images.HANDLE_WE.image());
        this.divider.setVisible(false);
        SashMouseTrackListener mouseTrackListener = new SashMouseTrackListener();
        host.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        this.divider.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        SashMouseMoveListener mouseMoveListener = new SashMouseMoveListener();
        host.addMouseMoveListener((MouseMoveListener)mouseMoveListener);
        this.divider.addMouseMoveListener(e -> {
            Point p = Display.getCurrent().map((Control)this.divider, (Control)host, new Point(e.x, e.y));
            e.x = p.x;
            e.y = p.y;
            mouseMoveListener.mouseMove(e);
        });
        SashMouseListener mouseListener = new SashMouseListener();
        host.addMouseListener((MouseListener)mouseListener);
        this.divider.addMouseListener((MouseListener)new SashMouseListener(this){

            @Override
            public void mouseDown(MouseEvent e) {
                Point p = Display.getCurrent().map((Control)divider, (Control)host, new Point(e.x, e.y));
                e.x = p.x;
                e.y = p.y;
                super.mouseDown(e);
            }
        });
    }

    public void addQuickNavigation(IMenuListener menuListener) {
        new ContextMenu((Control)this.divider, menuListener).hook();
    }

    protected void adjustSize(int curX, int curY) {
        List<Control> children = this.getChildren();
        Rectangle left = children.get(0).getBounds();
        Rectangle right = children.get(1).getBounds();
        if (left == null || right == null) {
            return;
        }
        int proposedSize = this.isHorizontal ? curX : curY;
        int totalSize = this.isHorizontal ? left.width + right.width : left.height + right.height;
        SashLayoutData data = this.getLayoutData(children.get(this.isBeginning ? 0 : 1));
        if (data.size > 0 || proposedSize > 20 && proposedSize < totalSize - 20) {
            proposedSize = Math.max(20, proposedSize);
            proposedSize = Math.min(totalSize - 20, proposedSize);
            data.size = this.isBeginning ? proposedSize : totalSize - proposedSize;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(500, 200);
    }

    public List<Control> getChildren() {
        Control[] children = this.host.getChildren();
        ArrayList<Control> answer = new ArrayList<Control>();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child != this.divider) {
                answer.add(child);
            }
            ++n2;
        }
        return answer;
    }

    public boolean isHidden() {
        SashLayoutData data = this.getLayoutData(this.getChildren().get(this.isBeginning ? 0 : 1));
        return data.size < 0;
    }

    public void flip() {
        SashLayoutData data = this.getLayoutData(this.getChildren().get(this.isBeginning ? 0 : 1));
        data.size *= -1;
        this.host.layout();
        this.host.update();
        this.divider.setVisible(false);
    }

    protected void layout(Composite composite, boolean flushCache) {
        List<Control> children = this.getChildren();
        if (children.size() != 2) {
            throw new IllegalArgumentException();
        }
        Rectangle bounds = composite.getBounds();
        if (composite instanceof Shell) {
            bounds = ((Shell)composite).getClientArea();
        } else {
            bounds.x = 0;
            bounds.y = 0;
        }
        int availableSize = (this.isHorizontal ? bounds.width : bounds.height) - 10;
        int fixedSize = Math.max(0, this.getLayoutData((Control)children.get((int)(this.isBeginning ? 0 : 1))).size);
        int remaining = Math.max(0, availableSize - fixedSize);
        int pos = this.isHorizontal ? bounds.x : bounds.y;
        pos += this.layout(children.get(0), pos, this.isBeginning ? fixedSize : remaining, bounds);
        pos += this.layoutDivider(pos, bounds);
        this.layout(children.get(1), pos, this.isBeginning ? remaining : fixedSize, bounds);
    }

    private int layout(Control control, int newPosition, int newSize, Rectangle bounds) {
        Rectangle subBounds = this.isHorizontal ? new Rectangle(newPosition, bounds.y, newSize, bounds.height) : new Rectangle(bounds.x, newPosition, bounds.width, newSize);
        control.setBounds(subBounds);
        return newSize;
    }

    private int layoutDivider(int newPosition, Rectangle bounds) {
        this.sash = this.isHorizontal ? new Rectangle(newPosition, bounds.y, 10, bounds.height) : new Rectangle(bounds.x, newPosition, bounds.width, 10);
        this.host.redraw(this.sash.x, this.sash.y, this.sash.width, this.sash.height, false);
        Rectangle imageBounds = this.divider.getImage().getBounds();
        Rectangle dividerBounds = this.isHorizontal ? new Rectangle(newPosition + (10 - imageBounds.width) / 2, (this.sash.height - imageBounds.height) / 2, imageBounds.width, imageBounds.height) : new Rectangle((this.sash.width - imageBounds.width) / 2, newPosition + (10 - imageBounds.height) / 2, imageBounds.width, imageBounds.height);
        this.divider.setBounds(dividerBounds);
        return 10;
    }

    private SashLayoutData getLayoutData(Control control) {
        SashLayoutData data = (SashLayoutData)control.getLayoutData();
        if (data == null) {
            data = new SashLayoutData();
            control.setLayoutData((Object)data);
        }
        return data;
    }

    private class SashMouseListener
    implements MouseListener {
        private SashMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            SashLayout.this.host.setCapture(false);
            SashLayout.this.isDragging = false;
        }

        public void mouseDown(MouseEvent e) {
            if (e.button != 1) {
                return;
            }
            if (SashLayout.this.sash.contains(e.x, e.y)) {
                SashLayout.this.isDragging = true;
                SashLayout.this.host.setCapture(true);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            SashLayout.this.flip();
        }
    }

    private class SashMouseMoveListener
    implements MouseMoveListener {
        private SashMouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (!SashLayout.this.isDragging) {
                if (SashLayout.this.sash.contains(e.x, e.y)) {
                    SashLayout.this.host.setCursor(SashLayout.this.host.getDisplay().getSystemCursor(SashLayout.this.isHorizontal ? 9 : 7));
                } else {
                    SashLayout.this.host.setCursor(SashLayout.this.host.getDisplay().getSystemCursor(0));
                }
            } else {
                SashLayout.this.adjustSize(e.x, e.y);
                SashLayout.this.host.layout();
                SashLayout.this.host.update();
            }
        }
    }

    private class SashMouseTrackListener
    extends MouseTrackAdapter {
        private SashMouseTrackListener() {
        }

        public void mouseExit(MouseEvent e) {
            SashLayout.this.host.setCursor(null);
            SashLayout.this.divider.setVisible(false);
        }

        public void mouseEnter(MouseEvent e) {
            SashLayout.this.divider.setVisible(true);
        }
    }
}

