/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.swt;

import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ColoredLabel
extends Canvas {
    private static final int MARGIN_HORIZONTAL = 2;
    private static final int MARGIN_VERTICAL = 1;
    private String text;
    private int textStyle = 16384;
    private Color textColor;
    private Color backdropColor;

    public ColoredLabel(Composite parent, int style) {
        super(parent, 0);
        this.textStyle = style;
        this.addListener(9, this::handlePaint);
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
        this.redraw();
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setBackdropColor(Color color) {
        this.backdropColor = color;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.text == null) {
            return new Point(0, 0);
        }
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        Point extent = gc.stringExtent(this.text);
        gc.dispose();
        return new Point(wHint == -1 ? extent.x + 4 : wHint, hHint == -1 ? extent.y + 2 : hHint);
    }

    private void handlePaint(Event e) {
        Rectangle bounds = this.getClientArea();
        Color background = this.backdropColor != null ? this.backdropColor : this.getBackground();
        e.gc.setBackground(background);
        e.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.text != null) {
            e.gc.setFont(this.getFont());
            Color foreground = this.getForeground();
            if (this.textColor != null) {
                foreground = this.textColor;
            } else if (this.backdropColor != null) {
                foreground = Colors.getTextColor(this.backdropColor);
            }
            e.gc.setForeground(foreground);
            Point extent = e.gc.stringExtent(this.text);
            int offsetX = 2;
            if ((this.textStyle & 0x20000) == 131072) {
                offsetX = bounds.width - extent.x - 2;
            } else if ((this.textStyle & 0x1000000) == 0x1000000) {
                offsetX = (bounds.width - extent.x) / 2;
            }
            int offsetY = (bounds.height - extent.y) / 2;
            e.gc.drawText(this.text, offsetX, offsetY, true);
        }
        e.type = 0;
    }
}

