/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.ISeries;

public class TimelineChartCSVExporter
extends AbstractCSVExporter {
    private final TimelineChart chart;
    private Set<String> discontinousSeries = new HashSet<String>();
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private NumberFormat valueFormat = new DecimalFormat("#,##0.00");

    public TimelineChartCSVExporter(TimelineChart viewer) {
        this.chart = viewer;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setValueFormat(NumberFormat valueFormat) {
        this.valueFormat = valueFormat;
    }

    public void addDiscontinousSeries(String seriesId) {
        this.discontinousSeries.add(seriesId);
    }

    @Override
    protected Shell getShell() {
        return this.chart.getShell();
    }

    @Override
    protected void writeToFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            ISeries[] series = this.chart.getSeriesSet().getSeries();
            printer.print((Object)Messages.ColumnDate);
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                printer.print((Object)s.getId());
                ++n2;
            }
            printer.println();
            Date[] dateSeries = series[0].getXDateSeries();
            SeriesAdapter[] adapters = new SeriesAdapter[series.length];
            int ii = 0;
            while (ii < series.length) {
                adapters[ii] = this.discontinousSeries.contains(series[ii].getId()) ? new DiscontinousAdapter(series[ii]) : new DefaultAdapter(series[ii]);
                ++ii;
            }
            int line = 0;
            while (line < dateSeries.length) {
                printer.print((Object)this.dateFormat.format(dateSeries[line]));
                int col = 0;
                while (col < adapters.length) {
                    printer.print((Object)adapters[col].format(dateSeries[line], line));
                    ++col;
                }
                printer.println();
                ++line;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class DefaultAdapter
    implements SeriesAdapter {
        private double[] values;

        public DefaultAdapter(ISeries series) {
            this.values = series.getYSeries();
        }

        @Override
        public String format(Date date, int line) {
            if (line >= this.values.length) {
                return "";
            }
            return TimelineChartCSVExporter.this.valueFormat.format(this.values[line]);
        }
    }

    private class DiscontinousAdapter
    implements SeriesAdapter {
        private Date[] dates;
        private double[] values;
        private int next = 0;

        public DiscontinousAdapter(ISeries series) {
            this.dates = series.getXDateSeries();
            this.values = series.getYSeries();
        }

        @Override
        public String format(Date date, int line) {
            if (this.next >= this.dates.length) {
                return "";
            }
            if (date.getTime() != this.dates[this.next].getTime()) {
                return "";
            }
            return TimelineChartCSVExporter.this.valueFormat.format(this.values[this.next++]);
        }
    }

    private static interface SeriesAdapter {
        public String format(Date var1, int var2);
    }
}

