/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.List;
import name.abuchen.portfolio.ui.util.chart.ChartContextMenu;
import name.abuchen.portfolio.ui.util.chart.ChartUtil;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.util.Dates;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class StackedTimelineChart
extends Chart {
    private TimelineChartToolTip toolTip;
    private List<LocalDate> dates;

    public StackedTimelineChart(Composite parent, List<LocalDate> dates) {
        super(parent, 0);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "chart");
        this.dates = dates;
        this.getLegend().setVisible(false);
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.getTick().setVisible(false);
        xAxis.getGrid().setStyle(LineStyle.NONE);
        String[] categories = new String[dates.size()];
        int ii = 0;
        while (ii < categories.length) {
            categories[ii] = dates.get(ii).toString();
            ++ii;
        }
        xAxis.setCategorySeries(categories);
        xAxis.enableCategory(true);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.setPosition(IAxis.Position.Secondary);
        ((IPlotArea)this.getPlotArea()).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                StackedTimelineChart.this.paintTimeGrid(e);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        this.toolTip = new TimelineChartToolTip(this);
        this.toolTip.enableCategory(true);
        this.toolTip.reverseLabels(true);
        this.toolTip.setValueFormat(new DecimalFormat("#0.0%"));
        new ChartContextMenu(this);
    }

    public ILineSeries addSeries(String label, double[] values, Color color) {
        ILineSeries series = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, label);
        series.setYSeries(values);
        series.setLineWidth(2);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setAntialias(1);
        series.enableStack(true);
        series.enableArea(true);
        series.setLineColor(color);
        return series;
    }

    public TimelineChartToolTip getToolTip() {
        return this.toolTip;
    }

    private void paintTimeGrid(PaintEvent e) {
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        Range range = xAxis.getRange();
        LocalDate start = this.dates.get(0);
        LocalDate end = this.dates.get(this.dates.size() - 1);
        int totalDays = Dates.daysBetween((LocalDate)start, (LocalDate)end) + 1;
        e.gc.setForeground(this.getAxisSet().getAxes()[0].getGrid().getForeground());
        LocalDate current = start.plusYears(1L).withDayOfYear(1);
        while (current.isBefore(end)) {
            int days = Dates.daysBetween((LocalDate)start, (LocalDate)current);
            int y = xAxis.getPixelCoordinate((double)days * range.upper / (double)totalDays);
            e.gc.drawLine(y, 0, y, e.height);
            e.gc.drawText(String.valueOf(current.getYear()), y + 5, 5);
            current = current.plusYears(1L);
        }
    }

    public void save(String filename, int format) {
        ChartUtil.save(this, filename, format);
    }
}

