/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import name.abuchen.portfolio.ui.util.chart.AbstractChartToolTip;
import name.abuchen.portfolio.ui.util.swt.ColoredLabel;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class ScatterChartToolTip
extends AbstractChartToolTip {
    public ScatterChartToolTip(Chart chart) {
        super(chart);
    }

    @Override
    protected Object getFocusObjectAt(Event event) {
        ISeries[] series = this.getChart().getSeriesSet().getSeries();
        ISeries closest = null;
        double minDist = Double.MAX_VALUE;
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            Point point = serie.getPixelCoordinates(0);
            double newDist = Math.sqrt(Math.pow(event.x - point.x, 2.0) + Math.pow(event.y - point.y, 2.0));
            if (newDist < minDist) {
                minDist = newDist;
                closest = serie;
            }
            ++n2;
        }
        return closest;
    }

    @Override
    protected void createComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackgroundMode(2);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        IAxis yAxis = this.getChart().getAxisSet().getYAxis(0);
        ILineSeries closest = (ILineSeries)this.getFocusedObject();
        Label left = new Label(container, 0);
        left.setText("");
        Label middle = new Label(container, 0);
        middle.setText(xAxis.getTitle().getText());
        Label right = new Label(container, 0);
        right.setText(yAxis.getTitle().getText());
        ColoredLabel cl = new ColoredLabel(container, 0);
        cl.setBackdropColor(closest.getSymbolColor());
        cl.setText(closest.getId());
        middle = new Label(container, 131072);
        middle.setText(xAxis.getTick().getFormat().format(closest.getXSeries()[0]));
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)middle);
        right = new Label(container, 131072);
        right.setText(yAxis.getTick().getFormat().format(closest.getYSeries()[0]));
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)right);
    }
}

