/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.chart.ScatterChart;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.ISeries;

public class ScatterChartCSVExporter
extends AbstractCSVExporter {
    private final ScatterChart chart;
    private NumberFormat valueFormat = new DecimalFormat("#,##0.00");

    public ScatterChartCSVExporter(ScatterChart viewer) {
        this.chart = viewer;
    }

    public void setValueFormat(NumberFormat valueFormat) {
        this.valueFormat = valueFormat;
    }

    @Override
    protected Shell getShell() {
        return this.chart.getShell();
    }

    @Override
    protected void writeToFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            ISeries[] series;
            printer.print((Object)Messages.ColumnDataSeries);
            printer.print((Object)this.chart.getAxisSet().getXAxis(0).getTitle().getText());
            printer.print((Object)this.chart.getAxisSet().getYAxis(0).getTitle().getText());
            printer.println();
            ISeries[] iSeriesArray = series = this.chart.getSeriesSet().getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                printer.print((Object)serie.getId());
                printer.print((Object)this.valueFormat.format(serie.getXSeries()[0]));
                printer.print((Object)this.valueFormat.format(serie.getYSeries()[0]));
                printer.println();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

