/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import name.abuchen.portfolio.ui.util.chart.ScatterChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.swtchart.Chart;
import org.swtchart.IAxis;

public class MovePlotKeyListener
implements Listener {
    private final Chart chart;

    private MovePlotKeyListener(Chart chart) {
        this.chart = chart;
    }

    public static void attachTo(Chart chart) {
        MovePlotKeyListener listener = new MovePlotKeyListener(chart);
        chart.getPlotArea().addListener(1, (Listener)listener);
    }

    public void handleEvent(Event event) {
        if (event.keyCode == 0x1000002) {
            this.arrowDown(event);
        } else if (event.keyCode == 0x1000001) {
            this.arrowUp(event);
        } else if (event.keyCode == 0x1000004) {
            this.arrowRight(event);
        } else if (event.keyCode == 0x1000003) {
            this.arrowLeft(event);
        } else if (event.character == '0') {
            this.adjustRange();
        }
    }

    private void arrowDown(Event event) {
        if (event.stateMask == SWT.MOD1) {
            IAxis[] iAxisArray = this.chart.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.zoomOut();
                ++n2;
            }
        } else {
            IAxis[] iAxisArray = this.chart.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                IAxis axis = iAxisArray[n3];
                axis.scrollDown();
                ++n3;
            }
        }
        this.chart.redraw();
    }

    private void arrowUp(Event event) {
        if (event.stateMask == SWT.MOD1) {
            IAxis[] iAxisArray = this.chart.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.zoomIn();
                ++n2;
            }
        } else {
            IAxis[] iAxisArray = this.chart.getAxisSet().getYAxes();
            int n = iAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                IAxis axis = iAxisArray[n3];
                axis.scrollUp();
                ++n3;
            }
        }
        this.chart.redraw();
    }

    private void arrowRight(Event event) {
        if (event.stateMask == SWT.MOD1) {
            IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.zoomOut();
                ++n2;
            }
        } else {
            IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                IAxis axis = iAxisArray[n3];
                axis.scrollUp();
                ++n3;
            }
        }
        this.chart.redraw();
    }

    private void arrowLeft(Event event) {
        if (event.stateMask == SWT.MOD1) {
            IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.zoomIn();
                ++n2;
            }
        } else {
            IAxis[] iAxisArray = this.chart.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n3 = 0;
            while (n3 < n) {
                IAxis axis = iAxisArray[n3];
                axis.scrollDown();
                ++n3;
            }
        }
        this.chart.redraw();
    }

    private void adjustRange() {
        if (this.chart instanceof ScatterChart) {
            ((ScatterChart)this.chart).adjustRange();
        } else if (this.chart instanceof TimelineChart) {
            ((TimelineChart)this.chart).adjustRange();
        } else {
            this.chart.getAxisSet().adjustRange();
        }
        this.chart.redraw();
    }
}

