/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import java.lang.reflect.InvocationTargetException;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.chart.ScatterChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.swtchart.Chart;
import org.swtchart.IAxis;

class ChartContextMenu {
    private static final String[] EXTENSIONS = new String[]{"*.jpeg", "*.jpg", "*.png"};
    private Chart chart;
    private Menu contextMenu;
    private static int lastUsedFileExtension = 0;

    public ChartContextMenu(Chart chart) {
        this.chart = chart;
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.configMenuAboutToShow(manager));
        this.contextMenu = menuMgr.createContextMenu((Control)chart);
        chart.getPlotArea().setMenu(this.contextMenu);
        chart.getPlotArea().addDisposeListener(e -> this.dispose());
    }

    private void configMenuAboutToShow(IMenuManager manager) {
        Action actionAdjustRange = new Action(Messages.MenuChartAdjustRange){

            public void run() {
                if (ChartContextMenu.this.chart instanceof ScatterChart) {
                    ((ScatterChart)ChartContextMenu.this.chart).adjustRange();
                } else if (ChartContextMenu.this.chart instanceof TimelineChart) {
                    ((TimelineChart)ChartContextMenu.this.chart).adjustRange();
                } else {
                    ChartContextMenu.this.chart.getAxisSet().adjustRange();
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionAdjustRange.setAccelerator(48);
        manager.add((IAction)actionAdjustRange);
        manager.add((IContributionItem)new Separator());
        this.addZoomActions(manager);
        manager.add((IContributionItem)new Separator());
        this.addMoveActions(manager);
        manager.add((IContributionItem)new Separator());
        this.exportMenuAboutToShow(manager, this.chart.getTitle().getText());
    }

    private void addZoomActions(IMenuManager manager) {
        Action actionZoomIn = new Action(Messages.MenuChartYZoomIn){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getYAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.zoomIn();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionZoomIn.setAccelerator(SWT.MOD1 | 0x1000001);
        manager.add((IAction)actionZoomIn);
        Action actionZoomOut = new Action(Messages.MenuChartYZoomOut){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getYAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.zoomOut();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionZoomOut.setAccelerator(SWT.MOD1 | 0x1000002);
        manager.add((IAction)actionZoomOut);
        Action actionYZoomIn = new Action(Messages.MenuChartXZoomOut){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.zoomIn();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionYZoomIn.setAccelerator(SWT.MOD1 | 0x1000003);
        manager.add((IAction)actionYZoomIn);
        Action actionXZoomOut = new Action(Messages.MenuChartXZoomIn){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.zoomOut();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionXZoomOut.setAccelerator(SWT.MOD1 | 0x1000004);
        manager.add((IAction)actionXZoomOut);
    }

    private void addMoveActions(IMenuManager manager) {
        Action actionMoveUp = new Action(Messages.MenuChartYScrollUp){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getYAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollUp();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionMoveUp.setAccelerator(0x1000001);
        manager.add((IAction)actionMoveUp);
        Action actionMoveDown = new Action(Messages.MenuChartYScrollDown){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getYAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollDown();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionMoveDown.setAccelerator(0x1000002);
        manager.add((IAction)actionMoveDown);
        Action actionMoveLeft = new Action(Messages.MenuChartXScrollDown){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollDown();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionMoveLeft.setAccelerator(0x1000003);
        manager.add((IAction)actionMoveLeft);
        Action actionMoveRight = new Action(Messages.MenuChartXScrollUp){

            public void run() {
                IAxis[] iAxisArray = ChartContextMenu.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.scrollUp();
                    ++n2;
                }
                ChartContextMenu.this.chart.redraw();
            }
        };
        actionMoveRight.setAccelerator(0x1000004);
        manager.add((IAction)actionMoveRight);
    }

    public void exportMenuAboutToShow(IMenuManager manager, final String label) {
        manager.add((IAction)new Action(Messages.MenuExportDiagram){

            public void run() {
                IRunnableWithProgress saveOperation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        FileDialog dialog = new FileDialog((this).ChartContextMenu.this.chart.getShell(), 8192);
                        dialog.setFileName(TextUtil.sanitizeFilename((String)label));
                        dialog.setFilterExtensions(EXTENSIONS);
                        dialog.setFilterIndex(lastUsedFileExtension);
                        dialog.setOverwrite(true);
                        String filename = dialog.open();
                        if (filename == null) {
                            return;
                        }
                        int format = filename.endsWith(".jpg") || filename.endsWith(".jpeg") ? 4 : (filename.endsWith(".png") ? 5 : -1);
                        lastUsedFileExtension = dialog.getFilterIndex();
                        if (lastUsedFileExtension == -1) {
                            lastUsedFileExtension = 0;
                        }
                        if (format != -1) {
                            boolean isChartTitleVisible = (this).ChartContextMenu.this.chart.getTitle().isVisible();
                            boolean isChartLegendVisible = (this).ChartContextMenu.this.chart.getLegend().isVisible();
                            try {
                                (this).ChartContextMenu.this.chart.suspendUpdate(true);
                                (this).ChartContextMenu.this.chart.getTitle().setVisible(true);
                                (this).ChartContextMenu.this.chart.getLegend().setVisible(true);
                                (this).ChartContextMenu.this.chart.getLegend().setPosition(1024);
                                (this).ChartContextMenu.this.chart.suspendUpdate(false);
                                (this).ChartContextMenu.this.chart.save(filename, format);
                            }
                            finally {
                                (this).ChartContextMenu.this.chart.suspendUpdate(true);
                                (this).ChartContextMenu.this.chart.getTitle().setVisible(isChartTitleVisible);
                                (this).ChartContextMenu.this.chart.getLegend().setVisible(isChartLegendVisible);
                                (this).ChartContextMenu.this.chart.suspendUpdate(false);
                            }
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(ChartContextMenu.this.chart.getShell()).run(false, false, saveOperation);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    PortfolioPlugin.log(e);
                }
            }
        });
    }

    private void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
    }
}

