/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.chart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.swtchart.Chart;

public abstract class AbstractChartToolTip
implements Listener {
    public static final int PADDING = 5;
    private Chart chart = null;
    private Shell tip = null;
    private Object focus = null;
    private boolean isAltPressed = false;

    public AbstractChartToolTip(Chart chart) {
        this.chart = chart;
        Composite plotArea = chart.getPlotArea();
        plotArea.addListener(3, (Listener)this);
        plotArea.addListener(5, (Listener)this);
        plotArea.addListener(4, (Listener)this);
        plotArea.addListener(12, (Listener)this);
    }

    protected abstract Object getFocusObjectAt(Event var1);

    protected abstract void createComposite(Composite var1);

    protected Chart getChart() {
        return this.chart;
    }

    protected Object getFocusedObject() {
        return this.focus;
    }

    protected boolean isAltPressed() {
        return this.isAltPressed;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 4: 
            case 12: {
                this.closeToolTip();
                break;
            }
            case 5: {
                this.moveToolTip(event);
                break;
            }
            case 3: {
                if (event.button != 1 || (event.stateMask & SWT.MOD1) == SWT.MOD1) break;
                this.isAltPressed = (event.stateMask & SWT.MOD3) == SWT.MOD3;
                this.showToolTip(event);
                break;
            }
        }
    }

    private void closeToolTip() {
        if (this.tip != null) {
            this.tip.dispose();
            this.tip = null;
        }
    }

    private Point createAndMeasureTooltip() {
        this.createComposite((Composite)this.tip);
        this.tip.layout();
        return this.tip.computeSize(-1, -1);
    }

    private void showToolTip(Event event) {
        this.focus = this.getFocusObjectAt(event);
        if (this.focus == null) {
            return;
        }
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = new Shell(Display.getDefault().getActiveShell(), 16388);
        this.tip.setLayout((Layout)new FillLayout());
        this.tip.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"tooltip");
        Point size = this.createAndMeasureTooltip();
        Rectangle bounds = this.calculateBounds(event, size);
        this.tip.setBounds(bounds);
        this.tip.setVisible(true);
    }

    private void moveToolTip(Event event) {
        boolean dateChanged;
        if (this.tip == null || this.tip.isDisposed()) {
            return;
        }
        Object newTipDate = this.getFocusObjectAt(event);
        boolean bl = dateChanged = this.focus != null && !this.focus.equals(newTipDate);
        if (dateChanged) {
            Control[] controlArray = this.tip.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.focus = newTipDate;
            Point size = this.createAndMeasureTooltip();
            Rectangle bounds = this.calculateBounds(event, size);
            this.tip.setBounds(bounds);
        } else {
            Point size = this.tip.getSize();
            Rectangle bounds = this.calculateBounds(event, size);
            this.tip.setLocation(new Point(bounds.x, bounds.y));
        }
    }

    private Rectangle calculateBounds(Event event, Point size) {
        Rectangle plotArea = this.chart.getPlotArea().getClientArea();
        int x = event.x + size.x / 2 > plotArea.width ? plotArea.width - size.x : event.x - size.x / 2;
        x = Math.max(x, 0);
        int y = event.y + size.y + 5 > plotArea.height ? event.y - size.y - 5 : event.y + 5;
        y = Math.max(y, 0);
        y = Math.min(y, plotArea.height - size.y - 5);
        Point pt = this.chart.getPlotArea().toDisplay(x, y);
        return new Rectangle(pt.x, pt.y, size.x, size.y);
    }
}

