/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.AbstractCSVExporter;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class TreeViewerCSVExporter
extends AbstractCSVExporter {
    private final TreeViewer viewer;

    public TreeViewerCSVExporter(TreeViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    protected Shell getShell() {
        return this.viewer.getTree().getShell();
    }

    @Override
    protected void writeToFile(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), STRATEGY);){
            ITreeContentProvider provider = (ITreeContentProvider)this.viewer.getContentProvider();
            int depth = this.depth(provider);
            int columnCount = this.viewer.getTree().getColumnCount();
            ILabelProvider[] labels = new ILabelProvider[columnCount];
            this.extractLabelProvider(labels);
            String label = this.viewer.getTree().getColumn(0).getText();
            int ii = 0;
            while (ii < depth) {
                printer.print((Object)(String.valueOf(label) + " " + (ii + 1)));
                ++ii;
            }
            ii = 1;
            while (ii < columnCount) {
                printer.print((Object)this.viewer.getTree().getColumn(ii).getText());
                ++ii;
            }
            printer.println();
            LinkedList<String> path = new LinkedList<String>();
            Object[] objectArray = provider.getElements(null);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.writeLine(printer, provider, labels, depth, path, element);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void extractLabelProvider(ILabelProvider[] labels) {
        int ii = 0;
        while (ii < labels.length) {
            CellLabelProvider blp = this.viewer.getLabelProvider(ii);
            labels[ii] = blp instanceof ILabelProvider ? (ILabelProvider)blp : (blp instanceof SharesLabelProvider ? new LabelProvider((IBaseLabelProvider)blp){
                private final /* synthetic */ IBaseLabelProvider val$blp;
                {
                    this.val$blp = iBaseLabelProvider;
                }

                public String getText(Object element) {
                    Long value = ((SharesLabelProvider)this.val$blp).getValue(element);
                    return value != null ? Values.Share.format((Object)value) : null;
                }
            } : new LabelProvider(){

                public String getText(Object element) {
                    return String.valueOf(element);
                }
            });
            ++ii;
        }
    }

    private void writeLine(CSVPrinter printer, ITreeContentProvider provider, ILabelProvider[] labels, int depth, LinkedList<String> path, Object element) throws IOException {
        path.add(labels[0].getText(element));
        for (String s : path) {
            printer.print((Object)s);
        }
        int ii = path.size();
        while (ii < depth) {
            printer.print((Object)"");
            ++ii;
        }
        ii = 1;
        while (ii < labels.length) {
            String text = labels[ii].getText(element);
            printer.print((Object)(text != null ? text : ""));
            ++ii;
        }
        printer.println();
        if (provider.hasChildren(element)) {
            Object[] objectArray = provider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.writeLine(printer, provider, labels, depth, path, child);
                ++n2;
            }
        }
        path.removeLast();
    }

    private int depth(ITreeContentProvider tree) {
        int depth = 0;
        Object[] objectArray = tree.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            depth = Math.max(depth, this.depth(tree, element, 1));
            ++n2;
        }
        return depth;
    }

    private int depth(ITreeContentProvider tree, Object element, int depth) {
        if (!tree.hasChildren(element)) {
            return depth;
        }
        int d = depth;
        Object[] objectArray = tree.getChildren(element);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            d = Math.max(d, this.depth(tree, child, depth + 1));
            ++n2;
        }
        return d;
    }
}

