/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.function.Consumer;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.util.TokenReplacingReader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class EmbeddedBrowser {
    private String htmlpage;
    private Browser browser;
    private IThemeEngine themeEngine;

    @Inject
    public EmbeddedBrowser(IThemeEngine engine) {
        this.themeEngine = engine;
    }

    public void setHtmlpage(String htmlpage) {
        this.htmlpage = htmlpage;
    }

    public Control createControl(Composite parent, Consumer<Browser> functions) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        try {
            this.browser = new Browser(container, 0);
            this.browser.setJavascriptEnabled(true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser);
            if (functions != null) {
                functions.accept(this.browser);
            }
            this.browser.setText(this.loadHTML(this.htmlpage));
            this.browser.addTraverseListener(event -> {
                boolean bl = event.doit = true;
            });
            Menu menu = new Menu((Control)this.browser);
            this.browser.setMenu(menu);
        }
        catch (SWTError e) {
            PortfolioPlugin.log(e);
            String stacktrace = Throwables.getStackTraceAsString((Throwable)e);
            Text text = new Text(container, 64);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
            text.setText(MessageFormat.format(Messages.MsgEmbeddedBrowserError, stacktrace));
        }
        return container;
    }

    public void refresh() {
        this.browser.setText(this.loadHTML(this.htmlpage));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String loadHTML(String htmlpage) {
        Scanner scanner = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream h = FileLocator.openStream((Bundle)PortfolioPlugin.getDefault().getBundle(), (IPath)new Path(htmlpage), (boolean)false);){
                try {
                    boolean isDark = this.themeEngine.getActiveTheme().getId().contains("dark");
                    scanner = new Scanner((Readable)new TokenReplacingReader((Reader)new InputStreamReader(h, StandardCharsets.UTF_8), (TokenReplacingReader.ITokenResolver)new PathResolver(isDark ? "dark" : "light")));
                    String string = scanner.useDelimiter("\\Z").next();
                    if (scanner != null) {
                        scanner.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (scanner != null) {
                        scanner.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | NoSuchElementException e) {
            Exception error = e;
            if (scanner != null && scanner.ioException() != null) {
                error = scanner.ioException();
            }
            PortfolioPlugin.log(error);
            return "<html><body><h1>" + error.getMessage() + "</h1></body></html>";
        }
    }

    private static final class PathResolver
    implements TokenReplacingReader.ITokenResolver {
        private Bundle bundle = PortfolioPlugin.getDefault().getBundle();
        private String cssTheme;

        public PathResolver(String cssTheme) {
            this.cssTheme = cssTheme;
        }

        public String resolveToken(String tokenName) throws IOException {
            try {
                tokenName = tokenName.replace("THEME", this.cssTheme);
                URL fileURL = FileLocator.toFileURL((URL)this.bundle.getEntry(tokenName));
                return "win32".equals(Platform.getOS()) ? fileURL.getPath().substring(1) : fileURL.getPath();
            }
            catch (NullPointerException e) {
                throw new IOException(e);
            }
        }
    }
}

