/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DropDown
extends ContributionItem {
    private String label;
    private String toolTip;
    private Images image;
    private int style;
    private IMenuListener menuListener;
    private IAction defaultAction;
    private ToolItem widget = null;
    private List<DisposeListener> disposeListeners = new ArrayList<DisposeListener>();

    public DropDown(String label) {
        this(label, null, 4, null);
    }

    public DropDown(String label, Images image) {
        this(label, image, 4, null);
    }

    public DropDown(String label, IMenuListener menuListener) {
        this(label, null, 4, menuListener);
    }

    public DropDown(String label, Images image, int style) {
        this(label, image, style, null);
    }

    public DropDown(String label, Images image, int style, IMenuListener menuListener) {
        this.label = label;
        this.image = image;
        this.style = style;
        this.menuListener = menuListener;
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.image != null && this.toolTip == null) {
                this.widget.setToolTipText(TextUtil.tooltip((String)label));
            }
            if (this.image == null || this.style == 4) {
                this.widget.setText(TextUtil.tooltip((String)label));
            }
            this.widget.getParent().getParent().layout();
        }
    }

    public final String getToolTip() {
        return this.toolTip;
    }

    public final void setToolTip(String toolTip) {
        this.toolTip = toolTip;
        if (this.widget != null && !this.widget.isDisposed()) {
            this.widget.setToolTipText(TextUtil.tooltip((String)toolTip));
        }
    }

    public Images getImage() {
        return this.image;
    }

    public final void setImage(Images image) {
        this.image = image;
        if (image != null && this.widget != null && !this.widget.isDisposed()) {
            this.widget.setImage(image.image());
        }
    }

    public final IMenuListener getMenuListener() {
        return this.menuListener;
    }

    public final void setMenuListener(IMenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public void setDefaultAction(IAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public final void addDisposeListener(DisposeListener listener) {
        this.disposeListeners.add(listener);
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem ti = new ToolItem(parent, this.style, index);
        if (this.image != null) {
            ti.setImage(this.image.image());
        }
        if (this.image == null || this.style == 4) {
            ti.setText(TextUtil.tooltip((String)this.label));
        }
        ti.setToolTipText(this.toolTip != null ? this.toolTip : this.label);
        ti.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (e.detail == 4 || this.defaultAction == null) {
                ToolItem item = (ToolItem)e.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(this.menuListener);
                Menu menu = menuMgr.createContextMenu((Control)item.getParent());
                menu.setLocation(pt.x, pt.y + rect.height);
                menu.setVisible(true);
                item.addDisposeListener(event -> menu.dispose());
            } else {
                this.defaultAction.run();
            }
        }));
        ti.addDisposeListener(e -> this.disposeListeners.forEach(l -> l.widgetDisposed(e)));
        this.widget = ti;
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        super.dispose();
    }
}

