/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import name.abuchen.portfolio.util.ColorConversion;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;

public final class Colors {
    public static final Color GRAY = Display.getDefault().getSystemColor(15);
    public static final Color WHITE = Display.getDefault().getSystemColor(1);
    public static final Color DARK_GRAY = Display.getDefault().getSystemColor(16);
    public static final Color DARK_RED = Display.getDefault().getSystemColor(4);
    public static final Color DARK_GREEN = Display.getDefault().getSystemColor(6);
    public static final Color BLACK = Display.getDefault().getSystemColor(2);
    public static final Color RED = Display.getDefault().getSystemColor(3);
    public static final Color GREEN = Display.getDefault().getSystemColor(5);
    private static final ColorRegistry REGISTRY = new ColorRegistry();
    public static final Color ICON_ORANGE = Colors.getColor(241, 143, 1);
    public static final Color ICON_BLUE = Colors.getColor(14, 110, 142);
    public static final Color ICON_GREEN = Colors.getColor(154, 193, 85);
    public static final Color TOTALS = Colors.getColor(0, 0, 0);
    public static final Color CASH = Colors.getColor(196, 55, 194);
    public static final Color EQUITY = Colors.getColor(87, 87, 255);
    public static final Color CPI = Colors.getColor(120, 120, 120);
    public static final Color IRR = Colors.getColor(0, 0, 0);
    public static final Color DARK_BLUE = Colors.getColor(149, 165, 180);
    public static final Color HEADINGS = Colors.getColor(57, 62, 66);
    public static final Color OTHER_CATEGORY = Colors.getColor(180, 180, 180);
    public static final Color INFO_TOOLTIP_BACKGROUND = Colors.getColor(236, 235, 236);
    public static final Color SIDEBAR_TEXT = Colors.getColor(57, 62, 66);
    public static final Color SIDEBAR_BACKGROUND = Colors.getColor(249, 250, 250);
    public static final Color SIDEBAR_BACKGROUND_SELECTED = Colors.getColor(228, 230, 233);
    public static final Color SIDEBAR_BORDER = Colors.getColor(244, 245, 245);
    private static final Theme theme = new Theme();

    private Colors() {
    }

    public static Theme theme() {
        return theme;
    }

    public static Color getColor(RGB rgb) {
        return Colors.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        String key = Colors.getColorKey(red, green, blue);
        if (REGISTRY.hasValueFor(key)) {
            return REGISTRY.get(key);
        }
        REGISTRY.put(key, new RGB(red, green, blue));
        return Colors.getColor(key);
    }

    private static Color getColor(String key) {
        return REGISTRY.get(key);
    }

    private static String getColorKey(int red, int green, int blue) {
        return String.valueOf(red) + "_" + green + "_" + blue;
    }

    public static String toHex(Color color) {
        return ColorConversion.toHex((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
    }

    public static String toHex(RGB rgb) {
        return ColorConversion.toHex((int)rgb.red, (int)rgb.green, (int)rgb.blue);
    }

    public static RGB toRGB(String hex) {
        int[] rgb = ColorConversion.toRGB((String)hex);
        return new RGB(rgb[0], rgb[1], rgb[2]);
    }

    public static Color getTextColor(Color color) {
        double luminance = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        return luminance < 0.4 ? BLACK : WHITE;
    }

    public static Color brighter(Color base) {
        return Colors.getColor(ColorConversion.brighter((RGB)base.getRGB()));
    }

    public static RGB interpolate(RGB first, RGB second, float factor) {
        int red = Math.round((float)first.red + factor * (float)(second.red - first.red));
        int green = Math.round((float)first.green + factor * (float)(second.green - first.green));
        int blue = Math.round((float)first.blue + factor * (float)(second.blue - first.blue));
        return new RGB(red, green, blue);
    }

    public static class Theme {
        private Color defaultForeground = BLACK;
        private Color defaultBackground = WHITE;
        private Color warningBackground = Colors.getColor(254, 223, 107);
        private Color redBackground = GREEN;
        private Color greenBackground = RED;
        private Color redForeground = DARK_RED;
        private Color greenForeground = DARK_GREEN;
        private Color hyperlink = Display.getDefault().getSystemColor(36);

        public Color defaultForeground() {
            return this.defaultForeground;
        }

        public void setDefaultForeground(RGBA color) {
            this.defaultForeground = Colors.getColor(color.rgb);
        }

        public Color defaultBackground() {
            return this.defaultBackground;
        }

        public void setDefaultBackground(RGBA color) {
            this.defaultBackground = Colors.getColor(color.rgb);
        }

        public Color warningBackground() {
            return this.warningBackground;
        }

        public void setWarningBackground(RGBA color) {
            this.warningBackground = Colors.getColor(color.rgb);
        }

        public Color redBackground() {
            return this.redBackground;
        }

        public void setRedBackground(RGBA color) {
            this.redBackground = Colors.getColor(color.rgb);
        }

        public Color greenBackground() {
            return this.greenBackground;
        }

        public void setGreenBackground(RGBA color) {
            this.greenBackground = Colors.getColor(color.rgb);
        }

        public Color redForeground() {
            return this.redForeground;
        }

        public void setRedForeground(RGBA color) {
            this.redForeground = Colors.getColor(color.rgb);
        }

        public Color greenForeground() {
            return this.greenForeground;
        }

        public void setGreenForeground(RGBA color) {
            this.greenForeground = Colors.getColor(color.rgb);
        }

        public Color hyperlink() {
            return this.hyperlink;
        }

        public void setHyperlink(RGBA color) {
            this.hyperlink = Colors.getColor(color.rgb);
        }
    }
}

